package com.hummer.im._internals.bridge.helper;

import com.hummer.im.model.id.User;

import static com.hummer.im._internals.bridge.helper.BlacklistEvent.EVENT_BLACKLIST_BLOCK;
import static com.hummer.im._internals.bridge.helper.BlacklistEvent.EVENT_BLACKLIST_IS_BLOCKED;
import static com.hummer.im._internals.bridge.helper.BlacklistEvent.EVENT_BLACKLIST_UNBLOCK;

public class BlacklistNative {

    public static void listBlacklist(long requestId) {
        BlacklistEvent.EventListBlacklist event = new BlacklistEvent.EventListBlacklist(requestId);
        HummerNative.sdkProcess(event);
    }

    public static void isBlocked(long requestId, User user) {
        BlacklistEvent.EventBlock event = new BlacklistEvent.EventBlock(requestId, user);
        event.event = EVENT_BLACKLIST_IS_BLOCKED;
        HummerNative.sdkProcess(event);
    }

    public static void block(long requestId, User user) {
        BlacklistEvent.EventBlock event = new BlacklistEvent.EventBlock(requestId, user);
        event.event = EVENT_BLACKLIST_BLOCK;
        HummerNative.sdkProcess(event);
    }

    public static void unblock(long requestId, User user) {
        BlacklistEvent.EventBlock event = new BlacklistEvent.EventBlock(requestId, user);
        event.event = EVENT_BLACKLIST_UNBLOCK;
        HummerNative.sdkProcess(event);
    }
}
