package com.hummer.im._internals.bridge.helper;

import com.hummer.im.model.id.User;

public class BlacklistEvent {

    public static final int EVENT_BLACKLIST_LIST_BLACKLIST = 701;
    public static final int EVENT_BLACKLIST_IS_BLOCKED = 702;
    public static final int EVENT_BLACKLIST_BLOCK = 703;
    public static final int EVENT_BLACKLIST_UNBLOCK = 704;


    public static class EventListBlacklist extends HummerEvent.EventBase {
        private final long requestId;

        EventListBlacklist(long requestId) {
            event = EVENT_BLACKLIST_LIST_BLACKLIST;
            this.requestId = requestId;
        }

        @Override
        public byte[] marshall() {
            pushInt64(requestId);
            return super.marshall();
        }
    }

    public static class EventBlock extends HummerEvent.EventBase {
        private final long requestId;
        private final User user;

        EventBlock(long requestId, User user) {
            event = EVENT_BLACKLIST_BLOCK;
            this.requestId = requestId;
            this.user = user;
        }

        @Override
        public byte[] marshall() {
            pushInt64(requestId);
            pushInt64(user == null ? 0 : user.getId());
            return super.marshall();
        }
    }

}
