/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.conversation._internals;

import com.hummer.im.HMR;
import com.hummer.im.conversation.ConversationService;
import com.hummer.im.conversation._internals.BeanMessage;
import com.hummer.im.conversation._internals.ConversationServiceImpl;
import com.hummer.im.id.IDFactory;
import com.hummer.im.id.Identifiable;
import com.hummer.im.services.chat.ChatContent;
import com.hummer.im.services.chat.ChatMessage;
import com.hummer.im.services.chat.ChatMessageStates;
import com.hummer.im.shared.CodecManager;
import com.hummer.im.shared.ServiceProvider;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public final class SPConversationModuleLoader
implements ServiceProvider.ModuleLoader {
    public void initModule() {
        SPConversationModuleLoader.registerChatMessageCodecs();
    }

    public Map<Class<? extends ServiceProvider.Service>, ServiceProvider.Service> getServices() {
        return new HashMap<Class<? extends ServiceProvider.Service>, ServiceProvider.Service>(){
            {
                this.put(ConversationService.class, new ConversationServiceImpl());
            }
        };
    }

    private static void registerChatMessageCodecs() {
        BeanMessage.codecs.register(SPConversationModuleLoader.generateCodec("hmr_text_message"));
        BeanMessage.codecs.register(SPConversationModuleLoader.generateCodec("chat_message"));
    }

    private static CodecManager.Codec<String, BeanMessage.DBMessageData, HMR.Message> generateCodec(final String string) {
        String string2 = "hmr_text_message";
        String string3 = "text";
        String string4 = "contentType";
        String string5 = "content";
        String string6 = "uuid";
        String string7 = "ts";
        String string8 = "sender";
        String string9 = "receiver";
        String string10 = "state";
        return new CodecManager.Codec<String, BeanMessage.DBMessageData, HMR.Message>(){

            public String getDataType() {
                return string;
            }

            public Class<? extends HMR.Message> getModelClass() {
                return ChatMessage.class;
            }

            public BeanMessage.DBMessageData encode(HMR.Message message) {
                ChatMessage chatMessage = (ChatMessage)message;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("uuid", (Object)chatMessage.getUuid());
                jSONObject.put("ts", chatMessage.getTimestamp());
                jSONObject.put("sender", (Object)IDFactory.toString((Identifiable)chatMessage.getSender()));
                jSONObject.put("receiver", (Object)IDFactory.toString((Identifiable)chatMessage.getReceiver()));
                jSONObject.put("state", (Object)ChatMessageStates.makeString((ChatMessageStates.State)chatMessage.getState()));
                jSONObject.put("contentType", (Object)ChatContent.getDataType((ChatContent)chatMessage.getContent()));
                jSONObject.put("content", (Object)ChatContent.makeString((ChatContent)chatMessage.getContent()));
                return new BeanMessage.DBMessageData(chatMessage.getUuid(), jSONObject.toString());
            }

            public HMR.Message decode(BeanMessage.DBMessageData dBMessageData) {
                JSONObject jSONObject = new JSONObject(dBMessageData.content);
                ChatMessage chatMessage = new ChatMessage();
                chatMessage.setUuid(jSONObject.getString("uuid"));
                chatMessage.setTimestamp(jSONObject.getLong("ts"));
                chatMessage.setSender(IDFactory.fromString((String)jSONObject.getString("sender")));
                chatMessage.setReceiver(IDFactory.fromString((String)jSONObject.getString("receiver")));
                chatMessage.setState(ChatMessageStates.makeState((String)jSONObject.getString("state")));
                if ("hmr_text_message".equals(this.getDataType())) {
                    chatMessage.setContent(ChatContent.makeContent((int)0, (String)jSONObject.getString("text")));
                } else {
                    int n = jSONObject.getInt("contentType");
                    chatMessage.setContent(ChatContent.makeContent((int)n, (String)jSONObject.getString("content")));
                }
                return chatMessage;
            }
        };
    }
}

