/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.conversation._internals;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.conversation.Conversation;
import com.hummer.im.conversation.ConversationService;
import com.hummer.im.conversation.FetchingClauses;
import com.hummer.im.conversation.RemovingClauses;
import com.hummer.im.conversation._internals.ActAddOrUpdateMessage;
import com.hummer.im.conversation._internals.ActFetchMessages;
import com.hummer.im.conversation._internals.ActFixConversationsIfNeeded;
import com.hummer.im.conversation._internals.ActGetPendingChatMessages;
import com.hummer.im.conversation._internals.ActRemoveMessages;
import com.hummer.im.conversation._internals.BeanConversation;
import com.hummer.im.conversation._internals.BeanMessage;
import com.hummer.im.db.DBActions;
import com.hummer.im.db.DBService;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.id.Identifiable;
import com.hummer.im.services.chat.ChatMessage;
import com.hummer.im.services.chat.ChatMessageStates;
import com.hummer.im.services.chat.ChatService;
import com.hummer.im.services.user.UserService;
import com.hummer.im.shared.DispatchQueue;
import com.hummer.im.shared.completion.Completion;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ConversationServiceImpl
implements ConversationService,
ChatService.MessageListener {
    private static final String TAG = "ConversationService";
    private final Map<Identifiable, Conversation> conversations = new HashMap<Identifiable, Conversation>();
    private final Set<ConversationService.ConversationListener> conversationListeners = new HashSet<ConversationService.ConversationListener>();
    private final Map<Identifiable, Set<ConversationService.MessageListener>> msgListeners = new HashMap<Identifiable, Set<ConversationService.MessageListener>>();
    private final Set<ConversationService.MessageListener> commonMsgListeners = new HashSet<ConversationService.MessageListener>();

    public Class[] staticDependencies() {
        return new Class[]{ChatService.class};
    }

    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class, DBService.class};
    }

    public Class[] plantingDynamicDependencies() {
        return new Class[]{ChatService.class};
    }

    public void initService() {
    }

    public void openService(@NonNull Completion completion) {
        DBActions dBActions = new DBActions().createTableIfNeeded(BeanConversation.class).queryAll(BeanConversation.class, list -> {
            for (BeanConversation beanConversation : list) {
                Conversation conversation = BeanConversation.toConversation(beanConversation);
                this.conversations.put(conversation.getTarget(), conversation);
            }
        });
        DBActions dBActions2 = new DBActions().createTableIfNeeded(BeanMessage.pendingConfig()).custom((DBService.Action)new ActGetPendingChatMessages(list -> {
            Error error = new Error(-1, "\u4ece\u5f02\u5e38\u4e2d\u6062\u590d", null);
            for (ChatMessage chatMessage : list) {
                chatMessage.setState((ChatMessageStates.State)new ChatMessageStates.Failed(error));
                Identifiable identifiable = ConversationService.targetFromMessage(chatMessage);
                Conversation conversation = this.getConversation(identifiable);
                if (conversation == null) continue;
                this.addOrUpdateMessage((HMR.Message)chatMessage, conversation, null);
            }
        })).deleteAll(BeanMessage.pendingConfig());
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().custom((DBService.Action)new ActFixConversationsIfNeeded()).custom((DBService.Action)dBActions).custom((DBService.Action)dBActions2).run("Hummer.Conversation.AddListener", () -> {
            ((ChatService)HMR.getService(ChatService.class)).addMessageListener((ChatService.MessageListener)this);
            this.notifyUpdateConversations();
        }), completion);
    }

    public void closeService() {
        HMRContext.work.async(() -> {
            ((ChatService)HMR.getService(ChatService.class)).removeMessageListener((ChatService.MessageListener)this);
            this.conversations.clear();
            this.notifyUpdateConversations();
        });
    }

    @Override
    public void createConversation(@NonNull Identifiable identifiable, @NonNull CompletionArg<Conversation> completionArg) {
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure(completionArg, (Error)new Error(1011, "Hummer not open"));
            return;
        }
        Conversation conversation = this.getConversation(identifiable);
        if (conversation == null) {
            Conversation conversation2 = conversation = new Conversation(identifiable, null);
            this.addConversation(conversation, new Completion().onSuccess(() -> CompletionUtils.dispatchSuccess((CompletionArg)completionArg, (Object)conversation2)).onFailure(error -> CompletionUtils.dispatchFailure((CompletionArg)completionArg, (Error)error)));
        } else {
            CompletionUtils.dispatchFailure(completionArg, (Error)new Error(1002, "\u4f1a\u8bdd\u5df2\u5b58\u5728"));
        }
    }

    @Override
    @Nullable
    public Conversation getConversation(@NonNull Identifiable identifiable) {
        if (HMR.getMe() == null) {
            return null;
        }
        return this.conversations.get(identifiable);
    }

    @Override
    @NonNull
    public List<Conversation> allConversations() {
        if (HMR.getMe() == null) {
            return new ArrayList<Conversation>();
        }
        return new ArrayList<Conversation>(this.conversations.values());
    }

    @Override
    public void addConversation(@NonNull Conversation conversation, @Nullable Completion completion) {
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure((Completion)completion, (Error)new Error(1011, "Hummer not open"));
            return;
        }
        Identifiable identifiable = conversation.getTarget();
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().guard(new Error(1002, "\u4f1a\u8bdd\u5df2\u5b58\u5728"), () -> this.conversations.containsKey(identifiable)).createTableIfNeeded(BeanMessage.conversationConfig(identifiable)).create((Object)BeanConversation.fromConversation(conversation), null).run("Hummer.AddConversation", () -> {
            this.conversations.put(identifiable, conversation);
            this.notifyAfterAddingConversation(conversation);
        }), completion);
    }

    @Override
    public void removeConversation(@NonNull Conversation conversation, @Nullable Completion completion) {
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure((Completion)completion, (Error)new Error(1011, "Hummer not open"));
            return;
        }
        Identifiable identifiable = conversation.getTarget();
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().guard(new Error(1002, "\u4f1a\u8bdd\u4e0d\u5b58\u5728"), () -> !this.conversations.containsKey(identifiable)).delete((Object)BeanConversation.fromConversation(conversation), null).dropTableIfExist(BeanMessage.conversationConfig(identifiable)).run("Hummer.DetachConversation", () -> {
            this.conversations.remove(identifiable);
            this.notifyAfterRemovingConversation(conversation);
        }), completion);
    }

    @Override
    public void updateConversation(@NonNull Conversation conversation, @NonNull Completion completion) {
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure((Completion)completion, (Error)new Error(1011, "Hummer not open"));
            return;
        }
        Identifiable identifiable = conversation.getTarget();
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().guard(new Error(1002, "\u4f1a\u8bdd\u4e0d\u5b58\u5728"), () -> !this.conversations.containsKey(identifiable)).update((Object)BeanConversation.fromConversation(conversation), null).run("Hummer.NotifyUpdateConversation", () -> this.notifyUpdateConversation(conversation)), completion);
    }

    @Override
    public void addOrUpdateMessage(final @NonNull HMR.Message message, final @NonNull Conversation conversation, @Nullable Completion completion) {
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure((Completion)completion, (Error)new Error(1011, "Hummer not open"));
            return;
        }
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new ActAddOrUpdateMessage(conversation, message, new ActAddOrUpdateMessage.Callback(){

            @Override
            public void beforeSaved(boolean bl) {
                if (bl) {
                    ConversationServiceImpl.this.notifyBeforeMessageAdding(conversation, message);
                }
            }

            @Override
            public void afterSaved(boolean bl) {
                if (bl) {
                    ConversationServiceImpl.this.notifyAfterMessageAdding(conversation, message);
                } else {
                    ConversationServiceImpl.this.notifyUpdateMessage(conversation, message);
                }
            }
        }));
    }

    @Override
    public void fetchMessages(@NonNull Conversation conversation, @NonNull FetchingClauses fetchingClauses, @Nullable CompletionArg<List<HMR.Message>> completionArg) {
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure(completionArg, (Error)new Error(1011, "Hummer not open"));
            return;
        }
        ActFetchMessages actFetchMessages = new ActFetchMessages(conversation, fetchingClauses);
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)actFetchMessages, new Completion().onSuccess(() -> CompletionUtils.dispatchSuccess((CompletionArg)completionArg, actFetchMessages.results)).onFailure(error -> CompletionUtils.dispatchFailure((CompletionArg)completionArg, (Error)error)));
    }

    @Override
    public void removeMessages(@NonNull Conversation conversation, @NonNull RemovingClauses removingClauses, @Nullable Completion completion) {
        if (HMR.getMe() == null) {
            CompletionUtils.dispatchFailure((Completion)completion, (Error)new Error(1011, "Hummer not open"));
            return;
        }
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().custom((DBService.Action)new ActRemoveMessages(conversation, removingClauses)).run("Hummer.NotifyAfterRemovingMessages", () -> this.notifyAfterMessagesRemoving(conversation, removingClauses)), completion);
    }

    @Override
    public void addConversationListener(@NonNull ConversationService.ConversationListener conversationListener) {
        HMRContext.work.async(() -> {
            this.conversationListeners.add(conversationListener);
            Log.i((String)TAG, (Object)Trace.once().method("addConversationListener").info("listener", (Object)conversationListener.getClass().getSimpleName()).info("size", (Object)this.conversationListeners.size()));
        });
    }

    @Override
    public void removeConversationListener(@NonNull ConversationService.ConversationListener conversationListener) {
        HMRContext.work.async(() -> {
            this.conversationListeners.remove(conversationListener);
            Log.i((String)TAG, (Object)Trace.once().method("removeConversationListener").info("listener", (Object)conversationListener.getClass().getSimpleName()).info("size", (Object)this.conversationListeners.size()));
        });
    }

    @Override
    public void addMessageListener(@NonNull ConversationService.MessageListener messageListener, @Nullable Conversation conversation) {
        HMRContext.work.async(() -> {
            if (conversation == null) {
                this.commonMsgListeners.add(messageListener);
                return;
            }
            Set<ConversationService.MessageListener> set = this.msgListeners.get(conversation.getTarget());
            if (set == null) {
                set = new HashSet<ConversationService.MessageListener>();
                this.msgListeners.put(conversation.getTarget(), set);
            }
            set.add(messageListener);
            Log.i((String)TAG, (Object)Trace.once().method("addMessageListener").info("conversation", (Object)conversation).info("listener", (Object)messageListener.getClass().getSimpleName()).info("size", (Object)this.conversationListeners.size()));
        });
    }

    @Override
    public void removeMessageListener(@NonNull ConversationService.MessageListener messageListener, @Nullable Conversation conversation) {
        HMRContext.work.async(() -> {
            Log.i((String)TAG, (Object)Trace.once().method("removeMessageListener").info("conversation", (Object)conversation).info("listener", (Object)messageListener.getClass().getSimpleName()).info("size", (Object)this.conversationListeners.size()));
            if (conversation == null) {
                this.commonMsgListeners.remove(messageListener);
                return;
            }
            Set<ConversationService.MessageListener> set = this.msgListeners.get(conversation.getTarget());
            if (set == null) {
                return;
            }
            set.remove(messageListener);
        });
    }

    private void notifyAfterAddingConversation(@NonNull Conversation conversation) {
        DispatchQueue.main.async(() -> {
            for (ConversationService.ConversationListener conversationListener : this.conversationListeners) {
                conversationListener.onAddConversation(conversation);
                conversationListener.onUpdateConversations(new ArrayList<Conversation>(this.conversations.values()));
            }
        });
    }

    private void notifyAfterRemovingConversation(@NonNull Conversation conversation) {
        DispatchQueue.main.async(() -> {
            for (ConversationService.ConversationListener conversationListener : this.conversationListeners) {
                conversationListener.onRemoveConversation(conversation);
                conversationListener.onUpdateConversations(new ArrayList<Conversation>(this.conversations.values()));
            }
        });
    }

    private void notifyUpdateConversations() {
        DispatchQueue.main.sync(() -> {
            for (ConversationService.ConversationListener conversationListener : this.conversationListeners) {
                conversationListener.onUpdateConversations(new ArrayList<Conversation>(this.conversations.values()));
            }
        });
    }

    private void notifyUpdateConversation(@NonNull Conversation conversation) {
        if (this.conversationListeners.size() == 0) {
            return;
        }
        DispatchQueue.main.sync(() -> {
            for (ConversationService.ConversationListener conversationListener : this.conversationListeners) {
                conversationListener.onUpdateConversation(conversation);
            }
        });
    }

    private void iterateMessageListeners(Conversation conversation, MessageListenersVisitor messageListenersVisitor) {
        DispatchQueue.main.sync(() -> {
            HashSet<ConversationService.MessageListener> hashSet = new HashSet<ConversationService.MessageListener>(this.commonMsgListeners);
            Set<ConversationService.MessageListener> set = this.msgListeners.get(conversation.getTarget());
            if (set != null) {
                hashSet.addAll(set);
            }
            for (ConversationService.MessageListener messageListener : hashSet) {
                messageListenersVisitor.visit(messageListener);
            }
        });
    }

    private void notifyBeforeMessageAdding(@NonNull Conversation conversation, @NonNull HMR.Message message) {
        this.iterateMessageListeners(conversation, messageListener -> messageListener.beforeAddingMessage(conversation, message));
    }

    private void notifyAfterMessageAdding(@NonNull Conversation conversation, @NonNull HMR.Message message) {
        this.iterateMessageListeners(conversation, messageListener -> messageListener.afterAddingMessage(conversation, message));
    }

    private void notifyUpdateMessage(@NonNull Conversation conversation, HMR.Message message) {
        this.iterateMessageListeners(conversation, messageListener -> messageListener.onUpdateMessage(conversation, message));
    }

    private void notifyAfterMessagesRemoving(@NonNull Conversation conversation, RemovingClauses removingClauses) {
        this.iterateMessageListeners(conversation, messageListener -> {
            if (removingClauses.messages == null) {
                messageListener.onClearMessages(conversation);
            } else {
                messageListener.afterRemovingMessages(conversation, removingClauses.messages);
            }
        });
    }

    public void beforeSendingMessage(@NonNull ChatMessage chatMessage) {
        HMRContext.work.async(() -> {
            if (chatMessage.getReceiver() instanceof ChatRoom) {
                return;
            }
            Conversation conversation = this.setupConversationIfNeeded(chatMessage);
            this.addOrUpdateMessage((HMR.Message)chatMessage, conversation, null);
            ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().create((Object)BeanMessage.fromMessage((HMR.Message)chatMessage, System.currentTimeMillis()), BeanMessage.pendingConfig()));
        });
    }

    public void onUpdateMessageState(@NonNull ChatMessage chatMessage, @NonNull ChatMessageStates.State state) {
        if (chatMessage.getReceiver() instanceof ChatRoom) {
            return;
        }
        if (state instanceof ChatMessageStates.Preparing) {
            return;
        }
        Identifiable identifiable = ConversationService.targetFromMessage(chatMessage);
        Conversation conversation = this.getConversation(identifiable);
        if (conversation == null) {
            return;
        }
        this.addOrUpdateMessage((HMR.Message)chatMessage, conversation, null);
    }

    public void afterSendingMessage(@NonNull ChatMessage chatMessage) {
        HMRContext.work.async(() -> {
            if (chatMessage.getReceiver() instanceof ChatRoom) {
                return;
            }
            ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().deleteById(BeanMessage.pendingConfig(), (Object)chatMessage.getUuid()));
        });
    }

    public void beforeReceivingMessage(@NonNull ChatMessage chatMessage) {
    }

    public void afterReceivingMessage(@NonNull ChatMessage chatMessage) {
        HMRContext.work.async(() -> {
            if (chatMessage.getReceiver() instanceof ChatRoom) {
                return;
            }
            Conversation conversation = this.setupConversationIfNeeded(chatMessage);
            this.addOrUpdateMessage((HMR.Message)chatMessage, conversation, null);
        });
    }

    private Conversation setupConversationIfNeeded(ChatMessage chatMessage) {
        Identifiable identifiable = ConversationService.targetFromMessage(chatMessage);
        Conversation conversation = this.getConversation(identifiable);
        if (conversation != null) {
            return conversation;
        }
        Conversation conversation2 = new Conversation(identifiable, null);
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().guard(null, () -> this.conversations.containsKey(identifiable)).createTableIfNeeded(BeanMessage.conversationConfig(identifiable)).createIfNotExists((Object)BeanConversation.fromConversation(conversation2), null).run("Hummer.Run.SetupConversationIfNeeded", () -> {
            Log.w((String)TAG, (Object)Trace.once().msg((Object)"Conversation Created!"));
            this.conversations.put(identifiable, conversation2);
            this.notifyAfterAddingConversation(conversation2);
        }));
        return conversation2;
    }

    static interface MessageListenersVisitor {
        public void visit(ConversationService.MessageListener var1);
    }
}

