/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.conversation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.HMR;
import com.hummer.im.conversation.Conversation;
import com.hummer.im.conversation.FetchingClauses;
import com.hummer.im.conversation.RemovingClauses;
import com.hummer.im.id.Group;
import com.hummer.im.id.Identifiable;
import com.hummer.im.services.chat.ChatMessage;
import com.hummer.im.shared.completion.Completion;
import com.hummer.im.shared.completion.CompletionArg;
import java.util.List;

public interface ConversationService
extends HMR.Service {
    public static Identifiable targetFromMessage(@NonNull ChatMessage chatMessage) {
        if (Identifiable.equals((Identifiable)chatMessage.getSender(), (Identifiable)HMR.getMe())) {
            return chatMessage.getReceiver();
        }
        if (chatMessage.getReceiver() instanceof Group) {
            return chatMessage.getReceiver();
        }
        return chatMessage.getSender();
    }

    public List<Conversation> allConversations();

    public Conversation getConversation(@NonNull Identifiable var1);

    public void createConversation(@NonNull Identifiable var1, @NonNull CompletionArg<Conversation> var2);

    public void addConversation(@NonNull Conversation var1, @Nullable Completion var2);

    public void removeConversation(@NonNull Conversation var1, @Nullable Completion var2);

    public void updateConversation(@NonNull Conversation var1, @NonNull Completion var2);

    public void addOrUpdateMessage(@NonNull HMR.Message var1, @NonNull Conversation var2, @Nullable Completion var3);

    public void fetchMessages(@NonNull Conversation var1, @NonNull FetchingClauses var2, @Nullable CompletionArg<List<HMR.Message>> var3);

    public void removeMessages(@NonNull Conversation var1, @NonNull RemovingClauses var2, @Nullable Completion var3);

    public void addConversationListener(@NonNull ConversationListener var1);

    public void removeConversationListener(@NonNull ConversationListener var1);

    public void addMessageListener(@NonNull MessageListener var1, @Nullable Conversation var2);

    public void removeMessageListener(@NonNull MessageListener var1, @Nullable Conversation var2);

    public static interface ConversationListener {
        default public void onAddConversation(@NonNull Conversation conversation) {
        }

        default public void onRemoveConversation(@NonNull Conversation conversation) {
        }

        default public void onUpdateConversation(@NonNull Conversation conversation) {
        }

        default public void onUpdateConversations(@NonNull List<Conversation> list) {
        }
    }

    public static interface MessageListener {
        default public void beforeAddingMessage(Conversation conversation, HMR.Message message) {
        }

        default public void afterAddingMessage(Conversation conversation, HMR.Message message) {
        }

        default public void beforeRemovingMessages(Conversation conversation, List<HMR.Message> list) {
        }

        default public void afterRemovingMessages(Conversation conversation, List<HMR.Message> list) {
        }

        default public void onClearMessages(Conversation conversation) {
        }

        default public void onUpdateMessage(Conversation conversation, HMR.Message message) {
        }
    }
}

