package com.hummer.im._internals;

import android.support.annotation.NonNull;

import com.hummer.im.model.Chat;
import com.hummer.im.db.DBService;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.store.FetchingClauses;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.table.DatabaseTableConfig;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ActFetchMessages implements DBService.Action {

    List<Message> results;

    ActFetchMessages(@NonNull Chat chat, @NonNull FetchingClauses clauses) {
        this.chat = chat;
        this.clauses = clauses;
    }

    @Override
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        DatabaseTableConfig<BeanMessage> tableConfig = BeanMessage.conversationConfig(chat.getTarget());
        String tableName = tableConfig.getTableName();
        QueryBuilder<BeanMessage, ?> queryBuilder = daoSet.create(tableConfig, null).queryBuilder();

        Where<BeanMessage, ?> where = queryBuilder.where();

        // 因为消息不会被真正移除，所以应过滤掉这些被标记为deleted的消息
        where.ne(BeanMessage.FieldDelFlag, true);

        if (clauses.getBeforeMessage() != null) {
            // 前面where已经有ne deleted语句，所以必须加上AND
            where.and();

            BeanMessage.DBMessageData anchorData = BeanMessage.codecs.encode(clauses.getBeforeMessage());
            String stmt = String.format(Locale.US, "rowId < (SELECT rowId FROM %s WHERE key='%s')",
                    tableName, anchorData.key);
            where.raw(stmt);
        }

        if (clauses.getLimit() != null) {
            queryBuilder.limit(Long.valueOf(clauses.getLimit()));
        }

        // queryBuilder.order(columnName, object) 只支持Bean中定义了DatabaseField注解的字段
        // 直接使用rowId这种sqlite内置字段会导致查询失败，因此只能用orderByRaw来进行查询
        queryBuilder.orderByRaw("rowId DESC");

        List<BeanMessage> dbMessages = queryBuilder.query();
        results = BeanMessage.toMessages(dbMessages);

        Collections.reverse(results);
    }

    @Override
    public String toString() {
        return "Hummer.FetchMessages "
                + "| chat: " + chat
                + ", clauses: " + clauses;
    }

    private final FetchingClauses clauses;
    private final Chat chat;

}
