package com.hummer.im._internals;

import com.hummer.im.HMR;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.db.DBActions;
import com.hummer.im.db.DBService;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.CompletionUtils;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;

import java.sql.SQLException;
import java.util.List;

public class ActChatUpgrade implements DBService.Action {

    private static String TAG = "ActChatUpgrade";

    @Override
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        Log.i(TAG, Trace.once("Upgrade conversation table"));
        final int oldVersion = HMR.getService(DBService.class).getOldVersion();
        final int newVersion = HMR.getService(DBService.class).getNewVersion();

        if (oldVersion == newVersion) {
            CompletionUtils.dispatchSuccess(completion);
            return;
        }

        final Dao<BeanConversation, ?> dao = daoSet.create(null, BeanConversation.class);

        if (oldVersion < newVersion) {
            if (oldVersion == 1) {
                String addLatestMsg = "ALTER TABLE `" + dao.getTableName() + "` ADD COLUMN "
                        + BeanConversation.FIELD_LATEST_MSG + " TEXT;";
                dao.executeRaw(addLatestMsg);
                String addUnreadNum = "ALTER TABLE `" + dao.getTableName() + "` ADD COLUMN "
                        + BeanConversation.FIELD_UNREAD_NUM + " INTEGER;";
                dao.executeRaw(addUnreadNum);
                String addTimestamp = "ALTER TABLE `" + dao.getTableName() + "` ADD COLUMN "
                        + BeanConversation.FIELD_TIMESTAMP + " REAL;";
                dao.executeRaw(addTimestamp);

                HMR.getService(DBService.class).execute(new DBActions()
                        .queryAll(BeanConversation.class,
                                new DBActions.QueryAcceptor<BeanConversation>() {
                                    @Override
                                    public void onQueryResults(List<BeanConversation> indexes) {
                                        for (BeanConversation index : indexes) {
                                            HMR.getService(DBService.class)
                                                    .execute(new ActUpdateChatLatestMsg(
                                                            BeanConversation.toConversation(index)));
                                        }
                                        CompletionUtils.dispatchSuccess(completion);
                                    }
                                }));
            }
        }
    }

    ActChatUpgrade(RichCompletion completion) {
        this.completion = completion;
    }

    private RichCompletion completion;
}
