/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import com.hummer.im._internals.BeanConversation;
import com.hummer.im._internals.BeanMessage;
import com.hummer.im._internals.ChatStoreServiceImpl;
import com.hummer.im._internals.ChatUpgradeService;
import com.hummer.im._internals.shared.CodecManager;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.states.StateFactory;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.service.ChatStoreService;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public final class SPChatStoreModuleLoader
implements ServiceProvider.ModuleLoader {
    public void initModule() {
        SPChatStoreModuleLoader.registerChatMessageCodecs();
    }

    public Map<Class, ServiceProvider.Service> getServices() {
        return new HashMap<Class, ServiceProvider.Service>(){
            {
                this.put(ChatStoreService.class, new ChatStoreServiceImpl());
                this.put(ChatUpgradeService.class, new ChatUpgradeService());
            }
        };
    }

    private static void registerChatMessageCodecs() {
        BeanMessage.codecs.register(SPChatStoreModuleLoader.generateCodec("hmr_text_message"));
        BeanMessage.codecs.register(SPChatStoreModuleLoader.generateCodec("chat_message"));
        BeanConversation.codecs.register(SPChatStoreModuleLoader.generateLatestMessageCodec());
    }

    private static CodecManager.Codec<String, String, Message> generateLatestMessageCodec() {
        String string = "hmr_text_message";
        String string2 = "text";
        String string3 = "contentType";
        String string4 = "content";
        String string5 = "uuid";
        String string6 = "ts";
        String string7 = "sender";
        String string8 = "receiver";
        String string9 = "state";
        return new CodecManager.Codec<String, String, Message>(){

            public String getDataType() {
                return "chat_latest_message";
            }

            public Class<? extends Message> getModelClass() {
                return Message.class;
            }

            public String encode(Message message) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("uuid", (Object)message.getUuid());
                jSONObject.put("ts", message.getTimestamp());
                jSONObject.put("sender", (Object)IDFactory.makeString((Identifiable)message.getSender()));
                jSONObject.put("receiver", (Object)IDFactory.makeString((Identifiable)message.getReceiver()));
                jSONObject.put("state", (Object)StateFactory.makeString((Message.State)message.getState()));
                jSONObject.put("contentType", (Object)Content.getDataType((Content)message.getContent()));
                jSONObject.put("content", (Object)Content.makeString((Content)message.getContent()));
                return jSONObject.toString();
            }

            public Message decode(String string) {
                JSONObject jSONObject = new JSONObject(string);
                Message message = new Message();
                message.setUuid(jSONObject.getString("uuid"));
                message.setTimestamp(jSONObject.getLong("ts"));
                message.setSender(IDFactory.makeId((String)jSONObject.getString("sender")));
                message.setReceiver(IDFactory.makeId((String)jSONObject.getString("receiver")));
                message.setState(StateFactory.makeState((String)jSONObject.getString("state")));
                if ("hmr_text_message".equals(this.getDataType())) {
                    message.setContent(Content.makeContent((int)0, (String)jSONObject.getString("text")));
                } else {
                    int n = jSONObject.getInt("contentType");
                    message.setContent(Content.makeContent((int)n, (String)jSONObject.getString("content")));
                }
                return message;
            }
        };
    }

    private static CodecManager.Codec<String, BeanMessage.DBMessageData, Message> generateCodec(final String string) {
        String string2 = "hmr_text_message";
        String string3 = "text";
        String string4 = "contentType";
        String string5 = "content";
        String string6 = "uuid";
        String string7 = "ts";
        String string8 = "sender";
        String string9 = "receiver";
        String string10 = "state";
        return new CodecManager.Codec<String, BeanMessage.DBMessageData, Message>(){

            public String getDataType() {
                return string;
            }

            public Class<? extends Message> getModelClass() {
                return Message.class;
            }

            public BeanMessage.DBMessageData encode(Message message) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("uuid", (Object)message.getUuid());
                jSONObject.put("ts", message.getTimestamp());
                jSONObject.put("sender", (Object)IDFactory.makeString((Identifiable)message.getSender()));
                jSONObject.put("receiver", (Object)IDFactory.makeString((Identifiable)message.getReceiver()));
                jSONObject.put("state", (Object)StateFactory.makeString((Message.State)message.getState()));
                jSONObject.put("contentType", (Object)Content.getDataType((Content)message.getContent()));
                jSONObject.put("content", (Object)Content.makeString((Content)message.getContent()));
                return new BeanMessage.DBMessageData(message.getUuid(), jSONObject.toString());
            }

            public Message decode(BeanMessage.DBMessageData dBMessageData) {
                JSONObject jSONObject = new JSONObject(dBMessageData.content);
                Message message = new Message();
                message.setUuid(jSONObject.getString("uuid"));
                message.setTimestamp(jSONObject.getLong("ts"));
                message.setSender(IDFactory.makeId((String)jSONObject.getString("sender")));
                message.setReceiver(IDFactory.makeId((String)jSONObject.getString("receiver")));
                message.setState(StateFactory.makeState((String)jSONObject.getString("state")));
                if ("hmr_text_message".equals(this.getDataType())) {
                    message.setContent(Content.makeContent((int)0, (String)jSONObject.getString("text")));
                } else {
                    int n = jSONObject.getInt("contentType");
                    message.setContent(Content.makeContent((int)n, (String)jSONObject.getString("content")));
                }
                return message;
            }
        };
    }
}

