/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.hummer.im._internals.BeanMessage;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.store.RemovingClauses;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableUtils;
import java.util.ArrayList;
import java.util.Locale;

public class ActRemoveMessages
implements DBService.Action {
    private static final String TAG = "RemoveMessages";
    private final RemovingClauses clauses;
    private final Chat chat;

    ActRemoveMessages(@NonNull Chat chat, @NonNull RemovingClauses removingClauses) {
        this.clauses = removingClauses;
        this.chat = chat;
    }

    public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
        Log.i((String)TAG, (Object)Trace.once((Object)this.chat.getTarget().toString()));
        DatabaseTableConfig<BeanMessage> databaseTableConfig = BeanMessage.conversationConfig(this.chat.getTarget());
        if (databaseTableConfig.getTableName() == null) {
            Log.e((String)"ActRemoveMessages", (Object)Trace.once().method("process").info("table name exception", null));
        }
        if (this.clauses.messages == null) {
            TableUtils.clearTable((ConnectionSource)ormLiteSqliteOpenHelper.getConnectionSource(), databaseTableConfig);
        } else if (this.clauses.messages.size() > 0) {
            Object object2;
            Dao dao = daoSet.create(databaseTableConfig, BeanMessage.class);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object2 : this.clauses.messages) {
                String string = ((BeanMessage.DBMessageData)BeanMessage.codecs.encode((Object)object2)).key;
                arrayList.add('\'' + string + '\'');
            }
            String string = TextUtils.join((CharSequence)",", arrayList);
            object2 = String.format(Locale.US, "UPDATE %s SET %s=1 WHERE key IN (%s)", databaseTableConfig.getTableName(), "deleted", string);
            dao.updateRaw((String)object2, new String[0]);
        }
    }

    public String toString() {
        return "Hummer.ActRemoveMessages | chat: " + this.chat + ", clauses: " + this.clauses;
    }
}

