package com.hummer.im._internals;

import android.support.annotation.NonNull;

import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.table.DatabaseTableConfig;

import java.sql.SQLException;
import java.util.List;

public class ActUpdateChatLatestMsg implements DBService.Action {

    private static final String TAG = "ActUpdateChatLatestMsg";

    private Chat chat;

    ActUpdateChatLatestMsg(@NonNull Chat chat) {
        this.chat = chat;
    }

    @Override
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        DatabaseTableConfig<BeanMessage> tableConfig = BeanMessage.conversationConfig(chat.getTarget());

        QueryBuilder<BeanMessage, ?> queryBuilder = daoSet.create(tableConfig, null).queryBuilder();
        queryBuilder.where().eq(BeanMessage.FieldDelFlag, false);
        queryBuilder.orderBy(BeanMessage.FieldTimestamp, false);
        queryBuilder.limit(1L);

        List<BeanMessage> beanMessageList = queryBuilder.query();
        if (beanMessageList.size() > 0) {
            Message message = BeanMessage.toMessage(beanMessageList.get(0));
            chat.setLatestMsg(message);
            chat.setTimestamp(message.getTimestamp());
        } else {
            chat.setLatestMsg(null);
            chat.setTimestamp(0L);
        }

        // 更新最后一条消息
        Dao<BeanConversation, ?> conversationDao = daoSet.create(null, BeanConversation.class);
        conversationDao.update(BeanConversation.fromConversation(chat));
    }
}
