package com.hummer.im._internals;

import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.store.RemovingClauses;
import com.hummer.im.db.DBService;
import com.hummer.im.model.chat.Message;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableUtils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * 虽然语义上是"删除"，但在数据库中，并不会真正的移除消息记录，而是简单的将其deleted标记设为true
 */
public class ActRemoveMessages implements DBService.Action {

    private static final String TAG = "RemoveMessages";

    ActRemoveMessages(@NonNull Chat chat, @NonNull RemovingClauses clauses) {
        this.clauses      = clauses;
        this.chat = chat;
    }

    @Override
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        Log.i(TAG, Trace.once(chat.getTarget().toString()));

        final DatabaseTableConfig<BeanMessage> config = BeanMessage.conversationConfig(chat.getTarget());

        if (config.getTableName() == null) {
            Log.e("ActRemoveMessages", Trace.once().method("process")
                    .info("table name exception", null));
        }

        if (clauses.messages == null) {
            TableUtils.clearTable(helper.getConnectionSource(), config);
        } else if (clauses.messages.size() > 0) {
            final Dao<BeanMessage, ?> dao = daoSet.create(config, BeanMessage.class);

            List<String> keys = new ArrayList<>();
            for (Message message : clauses.messages) {
                String key = BeanMessage.codecs.encode(message).key;
                keys.add('\'' + key + '\'');
            }

            String allKeys = TextUtils.join(",", keys);
            String stmt = String.format(Locale.US, "UPDATE %s SET %s=1 WHERE key IN (%s)",
                    config.getTableName(),
                    BeanMessage.FieldDelFlag,
                    allKeys);
            dao.updateRaw(stmt);
        }
    }

    @Override
    public String toString() {
        return "Hummer.ActRemoveMessages "
                + "| chat: " + chat
                + ", clauses: " + clauses;
    }

    private final RemovingClauses clauses;
    private final Chat chat;
}
