package com.hummer.im._internals;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.db.DBService;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;

import java.sql.SQLException;
import java.util.Locale;

public class ActResetChatUnreadNum implements DBService.Action {

    private static final String TAG = "ActResetConversationUnread";

    private static final String SQL = "update conversation_indexes set %s = 0 where name = '%s'";

    private Identifiable target;

    ActResetChatUnreadNum(Identifiable target) {
        this.target = target;
    }

    @Override
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        Log.i(TAG, Trace.once(target.toString()));

        String sql = String.format(Locale.US, SQL,
                BeanConversation.FIELD_UNREAD_NUM,
                IDFactory.makeString(target));
        final Dao<BeanConversation, ?> dao = daoSet.create(null, BeanConversation.class);
        dao.updateRaw(sql);
    }

    @Override
    public String toString() {
        return "Hummer.ResetUnread | target: " + target.getId();
    }
}
