package com.hummer.im._internals;

import android.support.annotation.NonNull;

import com.hummer.im.db.DBService;
import com.hummer.im.model.chat.Message;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ActGetPendingChatMessages implements DBService.Action {

    interface Acceptor {
        void onAcquired(List<Message> messages);
    }

    ActGetPendingChatMessages(@NonNull Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    @Override
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        List<BeanMessage> dbMessages = daoSet.create(BeanMessage.pendingConfig(), null).queryForAll();
        acceptor.onAcquired(new ArrayList<>(BeanMessage.toMessages(dbMessages)));
    }

    @Override
    public String toString() {
        return "Hummer." + getClass().getSimpleName();
    }

    private final Acceptor acceptor;
}
