package com.hummer.im._internals;

import com.hummer.im.model.Chat;
import com.hummer.im.db.DBService;
import com.hummer.im.model.chat.Message;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.table.DatabaseTableConfig;

import java.sql.SQLException;
import java.util.Locale;

public final class ActAddOrUpdateMessage implements DBService.Action {

    public interface Callback {
        void afterSaved(boolean isAdding);
    }

    ActAddOrUpdateMessage(Chat chat, Message message, Callback callback) {
        this.chat = chat;
        this.message      = message;
        this.completion   = callback;
    }

    @Override
    @SuppressWarnings("unchecked")
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        BeanMessage dbMessage = BeanMessage.fromMessage(message, System.currentTimeMillis());
        DatabaseTableConfig<BeanMessage> tableConfig = BeanMessage.conversationConfig(chat.getTarget());

        Dao<BeanMessage, String> dao = (Dao<BeanMessage, String>) daoSet.create(tableConfig, null);
        boolean notExisted = !dao.idExists(dbMessage.key);

        if (notExisted) {
            daoSet.create(tableConfig, null).create(dbMessage);
            completion.afterSaved(true);
        } else {
            String stmt = String.format(Locale.US, "UPDATE %s SET %s = ? WHERE key = ?",
                    tableConfig.getTableName(),
                    BeanMessage.FieldContent
            );
            daoSet.create(tableConfig, null).updateRaw(stmt, dbMessage.content, dbMessage.key);
            completion.afterSaved(false);
        }
    }

    @Override
    public String toString() {
        return "Hummer.ActAddOrUpdateMessage "
                + "| chat: " + chat
                + ", message: " + message;
    }

    private final Message      message;
    private final Chat chat;
    private final Callback     completion;
}
