/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.ActAddOrUpdateMessage;
import com.hummer.im._internals.ActFetchMessages;
import com.hummer.im._internals.ActFixConversationsIfNeeded;
import com.hummer.im._internals.ActGetPendingChatMessages;
import com.hummer.im._internals.ActRemoveMessages;
import com.hummer.im._internals.ActResetChatUnreadNum;
import com.hummer.im._internals.ActUpdateChatLatestMsg;
import com.hummer.im._internals.BeanConversation;
import com.hummer.im._internals.BeanMessage;
import com.hummer.im._internals.ChatUpgradeService;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.db.DBActions;
import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.states.Failed;
import com.hummer.im.model.chat.states.Preparing;
import com.hummer.im.model.chat.store.FetchingClauses;
import com.hummer.im.model.chat.store.RemovingClauses;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccess;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.AppSession;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im.service.ChatService;
import com.hummer.im.service.ChatStoreService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ChatStoreServiceImpl
implements ServiceProvider.Service,
ChatService.MessageListener,
ChatService.StateListener,
ChatStoreService {
    private static final String TAG = "ChatStoreService";
    private final Map<Identifiable, Chat> chats = new HashMap<Identifiable, Chat>();
    private final Set<ChatStoreService.ChatListener> chatListeners = new HashSet<ChatStoreService.ChatListener>();
    private final Map<Identifiable, Set<ChatStoreService.MessageListener>> msgListeners = new HashMap<Identifiable, Set<ChatStoreService.MessageListener>>();
    private final Set<ChatStoreService.MessageListener> commonMsgListeners = new HashSet<ChatStoreService.MessageListener>();
    private ChatStoreService.Filter filter = new ChatStoreService.Filter(){

        @Override
        public boolean shouldAcceptMessage(Message message) {
            return message.getTarget() instanceof User;
        }
    };

    public Class[] staticDependencies() {
        return new Class[]{ChatService.class};
    }

    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class, ChatUpgradeService.class};
    }

    public Class[] plantingDynamicDependencies() {
        return new Class[]{ChatService.class};
    }

    public void initService() {
    }

    public void openService(@NonNull RichCompletion richCompletion) {
        DBActions dBActions = new DBActions().createTableIfNeeded(BeanConversation.class).queryAll(BeanConversation.class, (DBActions.QueryAcceptor)new DBActions.QueryAcceptor<BeanConversation>(){

            public void onQueryResults(List<BeanConversation> list) {
                for (BeanConversation beanConversation : list) {
                    Chat chat = BeanConversation.toConversation(beanConversation);
                    ChatStoreServiceImpl.this.chats.put(chat.getTarget(), chat);
                }
            }
        });
        DBActions dBActions2 = new DBActions().createTableIfNeeded(BeanMessage.pendingConfig()).custom((DBService.Action)new ActGetPendingChatMessages(new ActGetPendingChatMessages.Acceptor(){

            @Override
            public void onAcquired(List<Message> list) {
                Error error = new Error(-1, "\u4ece\u5f02\u5e38\u4e2d\u6062\u590d", null);
                for (Message message : list) {
                    message.setState((Message.State)new Failed(error));
                    Identifiable identifiable = message.getTarget();
                    if (identifiable == null) {
                        return;
                    }
                    Chat chat = ChatStoreServiceImpl.this.getChat(identifiable);
                    if (chat == null) continue;
                    ChatStoreServiceImpl.this.addOrUpdateMessage(chat, message, null);
                }
            }
        })).deleteAll(BeanMessage.pendingConfig());
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().custom((DBService.Action)new ActFixConversationsIfNeeded()).custom((DBService.Action)dBActions).custom((DBService.Action)dBActions2).run("Hummer.Chat.AddListener", new Runnable(){

            @Override
            public void run() {
                ((ChatService)HMR.getService(ChatService.class)).addStateListener(null, (ChatService.StateListener)ChatStoreServiceImpl.this);
                ((ChatService)HMR.getService(ChatService.class)).addMessageListener(null, (ChatService.MessageListener)ChatStoreServiceImpl.this);
                ChatStoreServiceImpl.this.notifyUpdateConversations();
            }
        }), richCompletion);
    }

    public void closeService() {
        ((ChatService)HMR.getService(ChatService.class)).removeMessageListener(null, (ChatService.MessageListener)this);
        this.chats.clear();
        this.notifyUpdateConversations();
    }

    @Override
    public void createChat(@NonNull Identifiable identifiable, @NonNull HMR.CompletionArg<Chat> completionArg) {
        final RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatStoreService::createChat");
        if (HMR.getMe() == null || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "Hummer not open, or using anonymous mode"));
            return;
        }
        Chat chat = this.getChat(identifiable);
        if (chat == null) {
            final Chat chat2 = chat = new Chat(identifiable, null, 0L, null, System.currentTimeMillis());
            this.addChat(chat, new HMR.Completion(){

                public void onSuccess() {
                    CompletionUtils.dispatchSuccess((RichCompletionArg)richCompletionArg, (Object)chat2);
                }

                public void onFailed(Error error) {
                    CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)error);
                }
            });
        } else {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1002, "\u4f1a\u8bdd\u5df2\u5b58\u5728"));
        }
    }

    @Override
    @Nullable
    public Chat getChat(@NonNull Identifiable identifiable) {
        if (HMR.getMe() == null || HMR.getMe().isAnonymous()) {
            Log.e((String)TAG, (Object)Trace.once((Object)"getChat").msg((Object)"User not login, or using anonymous mode"));
            return null;
        }
        return this.chats.get(identifiable);
    }

    @Override
    @NonNull
    public List<Chat> getChats() {
        if (HMR.getMe() == null || HMR.getMe().isAnonymous()) {
            Log.e((String)TAG, (Object)Trace.once((Object)"getChats").msg((Object)"User not login, or using anonymous mode"));
            return new ArrayList<Chat>();
        }
        return new ArrayList<Chat>(this.chats.values());
    }

    @Override
    public void addChat(final @NonNull Chat chat, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatStoreService::addChat");
        if (HMR.getMe() == null || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "Hummer not open, or using anonymous mode"));
            return;
        }
        final Identifiable identifiable = chat.getTarget();
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().guard(new Error(1002, "\u4f1a\u8bdd\u5df2\u5b58\u5728"), new DBActions.Guarder(){

            public boolean shouldBreak() {
                return ChatStoreServiceImpl.this.chats.containsKey(identifiable);
            }
        }).createTableIfNeeded(BeanMessage.conversationConfig(identifiable)).create((Object)BeanConversation.fromConversation(chat), null).run("Hummer.AddConversation", new Runnable(){

            @Override
            public void run() {
                ChatStoreServiceImpl.this.chats.put(identifiable, chat);
                ChatStoreServiceImpl.this.notifyAfterAddingConversation(chat);
            }
        }), richCompletion);
    }

    @Override
    public void removeChat(final @NonNull Chat chat, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatStoreService::removeChat");
        if (HMR.getMe() == null || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "Hummer not open, or using anonymous mode"));
            return;
        }
        final Identifiable identifiable = chat.getTarget();
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().guard(new Error(1002, "\u4f1a\u8bdd\u4e0d\u5b58\u5728"), new DBActions.Guarder(){

            public boolean shouldBreak() {
                return !ChatStoreServiceImpl.this.chats.containsKey(identifiable);
            }
        }).delete((Object)BeanConversation.fromConversation(chat), null).dropTableIfExist(BeanMessage.conversationConfig(identifiable)).run("Hummer.DetachConversation", new Runnable(){

            @Override
            public void run() {
                ChatStoreServiceImpl.this.chats.remove(identifiable);
                ChatStoreServiceImpl.this.notifyAfterRemovingConversation(chat);
            }
        }), richCompletion);
    }

    @Override
    public void updateChat(final @NonNull Chat chat, @NonNull HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatStoreService::updateChat");
        if (HMR.getMe() == null || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "Hummer not open, or using anonymous mode"));
            return;
        }
        final Identifiable identifiable = chat.getTarget();
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().guard(new Error(1002, "\u4f1a\u8bdd\u4e0d\u5b58\u5728"), new DBActions.Guarder(){

            public boolean shouldBreak() {
                return !ChatStoreServiceImpl.this.chats.containsKey(identifiable);
            }
        }).update((Object)BeanConversation.fromConversation(chat), null).run("Hummer.NotifyUpdateConversation", new Runnable(){

            @Override
            public void run() {
                ChatStoreServiceImpl.this.notifyUpdateConversation(chat);
            }
        }), richCompletion);
    }

    @Override
    public void resetUnread(final @NonNull Chat chat, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatStoreService::resetUnread");
        if (HMR.getMe() == null || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "Hummer not open, or using anonymous mode"));
            return;
        }
        chat.setUnreadNum(0L);
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().custom((DBService.Action)new ActResetChatUnreadNum(chat.getTarget())).run("Hummer.resetUnread", new Runnable(){

            @Override
            public void run() {
                ChatStoreServiceImpl.this.chats.put(chat.getTarget(), chat);
                ChatStoreServiceImpl.this.notifyUpdateConversation(chat);
            }
        }), richCompletion);
    }

    @Override
    public void addOrUpdateMessage(final @NonNull Chat chat, final @NonNull Message message, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatStoreService::addOrUpdateMessage");
        if (HMR.getMe() == null || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "Hummer not open, or using anonymous mode"));
            return;
        }
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new ActAddOrUpdateMessage(chat, message, new ActAddOrUpdateMessage.Callback(){

            @Override
            public void afterSaved(boolean bl) {
                if (bl) {
                    if (!HMR.isMe((Identifiable)message.getSender())) {
                        chat.setUnreadNum(chat.getUnreadNum() + 1L);
                    }
                    chat.setLatestMsg(message);
                    chat.setTimestamp(message.getTimestamp());
                    ChatStoreServiceImpl.this.chats.put(chat.getTarget(), chat);
                    ((ChatStoreService)HMR.getService(ChatStoreService.class)).updateChat(chat, new HMR.Completion(){

                        public void onSuccess() {
                            ChatStoreServiceImpl.this.notifyAfterMessageAdding(chat, message);
                        }

                        public void onFailed(Error error) {
                        }
                    });
                } else if (chat.getLatestMsg().getUuid().equals(message.getUuid())) {
                    ((ChatStoreService)HMR.getService(ChatStoreService.class)).updateChat(chat, new HMR.Completion(){

                        public void onSuccess() {
                            ChatStoreServiceImpl.this.notifyUpdateMessage(chat, message);
                        }

                        public void onFailed(Error error) {
                        }
                    });
                } else {
                    ChatStoreServiceImpl.this.notifyUpdateMessage(chat, message);
                }
            }
        }), richCompletion);
    }

    @Override
    public void fetchMessages(@NonNull Chat chat, @NonNull FetchingClauses fetchingClauses, @Nullable HMR.CompletionArg<List<Message>> completionArg) {
        final RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatStoreService::fetchMessages");
        if (HMR.getMe() == null || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "Hummer not open, or using anonymous mode"));
            return;
        }
        final ActFetchMessages actFetchMessages = new ActFetchMessages(chat, fetchingClauses);
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)actFetchMessages, new RichCompletion("ChatStoreService::fetchMessages").onSuccess(new OnSuccess(){

            public void onSuccess() {
                CompletionUtils.dispatchSuccess((RichCompletionArg)richCompletionArg, actFetchMessages.results);
            }
        }).onFailure(new OnFailure(){

            public void onFailure(Error error) {
                CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)error);
            }
        }));
    }

    @Override
    public void removeMessages(final @NonNull Chat chat, final @NonNull RemovingClauses removingClauses, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatStoreService::removeMessages");
        if (HMR.getMe() == null || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "Hummer not open, or using anonymous mode"));
            return;
        }
        if (removingClauses.messages != null) {
            this.notifyBeforeMessagesRemoving(chat, removingClauses.messages);
        }
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().custom((DBService.Action)new ActRemoveMessages(chat, removingClauses)).custom((DBService.Action)new ActUpdateChatLatestMsg(chat)).run("Hummer.NotifyAfterRemovingMessages", new Runnable(){

            @Override
            public void run() {
                if (removingClauses.messages == null) {
                    ChatStoreServiceImpl.this.notifyAfterMessagesClear(chat);
                }
            }
        }), richCompletion);
    }

    @Override
    public void addChatListener(final @NonNull ChatStoreService.ChatListener chatListener) {
        HMRContext.work.async("ChatStore::addChatListener", new Runnable(){

            @Override
            public void run() {
                ChatStoreServiceImpl.this.chatListeners.add(chatListener);
                Log.i((String)ChatStoreServiceImpl.TAG, (Object)Trace.once().method("addChatListener").info("listener", (Object)chatListener.getClass().getSimpleName()).info("size", (Object)ChatStoreServiceImpl.this.chatListeners.size()));
            }
        });
    }

    @Override
    public void removeChatListener(final @NonNull ChatStoreService.ChatListener chatListener) {
        HMRContext.work.async("ChatStore::removeChatListener", new Runnable(){

            @Override
            public void run() {
                ChatStoreServiceImpl.this.chatListeners.remove(chatListener);
                Log.i((String)ChatStoreServiceImpl.TAG, (Object)Trace.once().method("removeChatListener").info("listener", (Object)chatListener.getClass().getSimpleName()).info("size", (Object)ChatStoreServiceImpl.this.chatListeners.size()));
            }
        });
    }

    @Override
    public void addMessageListener(final @Nullable Chat chat, final @NonNull ChatStoreService.MessageListener messageListener) {
        HMRContext.work.async("ChatStore::addMessageListener", new Runnable(){

            @Override
            public void run() {
                if (chat == null) {
                    ChatStoreServiceImpl.this.commonMsgListeners.add(messageListener);
                    return;
                }
                HashSet<ChatStoreService.MessageListener> hashSet = (HashSet<ChatStoreService.MessageListener>)ChatStoreServiceImpl.this.msgListeners.get(chat.getTarget());
                if (hashSet == null) {
                    hashSet = new HashSet<ChatStoreService.MessageListener>();
                    ChatStoreServiceImpl.this.msgListeners.put(chat.getTarget(), hashSet);
                }
                hashSet.add(messageListener);
                Log.i((String)ChatStoreServiceImpl.TAG, (Object)Trace.once().method("addMessageListener").info("chat", (Object)chat).info("listener", (Object)messageListener.getClass().getSimpleName()).info("size", (Object)ChatStoreServiceImpl.this.chatListeners.size()));
            }
        });
    }

    @Override
    public void removeMessageListener(final @Nullable Chat chat, final @NonNull ChatStoreService.MessageListener messageListener) {
        HMRContext.work.async("ChatStore::removeMessageListener", new Runnable(){

            @Override
            public void run() {
                Log.i((String)ChatStoreServiceImpl.TAG, (Object)Trace.once().method("removeMessageListener").info("chat", (Object)chat).info("listener", (Object)messageListener.getClass().getSimpleName()).info("size", (Object)ChatStoreServiceImpl.this.chatListeners.size()));
                if (chat == null) {
                    ChatStoreServiceImpl.this.commonMsgListeners.remove(messageListener);
                    return;
                }
                Set set = (Set)ChatStoreServiceImpl.this.msgListeners.get(chat.getTarget());
                if (set == null) {
                    return;
                }
                set.remove(messageListener);
            }
        });
    }

    private void notifyAfterAddingConversation(final @NonNull Chat chat) {
        DispatchQueue.main.async("ChatStore::notifyAfterAddingConversation", new Runnable(){

            @Override
            public void run() {
                for (ChatStoreService.ChatListener chatListener : ChatStoreServiceImpl.this.chatListeners) {
                    chatListener.afterCreatingChat(chat);
                    chatListener.afterUpdateChats(new ArrayList<Chat>(ChatStoreServiceImpl.this.chats.values()));
                }
            }
        });
    }

    private void notifyAfterRemovingConversation(final @NonNull Chat chat) {
        DispatchQueue.main.async("ChatStore::notifyAfterRemovingConversation", new Runnable(){

            @Override
            public void run() {
                for (ChatStoreService.ChatListener chatListener : ChatStoreServiceImpl.this.chatListeners) {
                    chatListener.beforeRemovingChat(chat);
                    chatListener.afterUpdateChats(new ArrayList<Chat>(ChatStoreServiceImpl.this.chats.values()));
                }
            }
        });
    }

    private void notifyUpdateConversations() {
        DispatchQueue.main.sync("ChatStore::notifyUpdateConversations", new Runnable(){

            @Override
            public void run() {
                for (ChatStoreService.ChatListener chatListener : ChatStoreServiceImpl.this.chatListeners) {
                    chatListener.afterUpdateChats(new ArrayList<Chat>(ChatStoreServiceImpl.this.chats.values()));
                }
            }
        });
    }

    private void notifyUpdateConversation(final @NonNull Chat chat) {
        if (this.chatListeners.size() == 0) {
            return;
        }
        DispatchQueue.main.sync("ChatStore::notifyUpdateConversation", new Runnable(){

            @Override
            public void run() {
                for (ChatStoreService.ChatListener chatListener : ChatStoreServiceImpl.this.chatListeners) {
                    chatListener.afterUpdateChat(chat);
                }
            }
        });
    }

    private void iterateMessageListeners(final Chat chat, final MessageListenersVisitor messageListenersVisitor) {
        DispatchQueue.main.sync("ChatStore::" + messageListenersVisitor.visitorName(), new Runnable(){

            @Override
            public void run() {
                HashSet hashSet = new HashSet(ChatStoreServiceImpl.this.commonMsgListeners);
                Set set = (Set)ChatStoreServiceImpl.this.msgListeners.get(chat.getTarget());
                if (set != null) {
                    hashSet.addAll(set);
                }
                for (ChatStoreService.MessageListener messageListener : hashSet) {
                    messageListenersVisitor.visit(messageListener);
                }
            }
        });
    }

    private void notifyAfterMessageAdding(final @NonNull Chat chat, final @NonNull Message message) {
        this.iterateMessageListeners(chat, new MessageListenersVisitor(){

            @Override
            public void visit(ChatStoreService.MessageListener messageListener) {
                messageListener.afterAddingMessage(chat, message);
            }

            @Override
            public String visitorName() {
                return "notifyAfterMessageAdding";
            }
        });
    }

    private void notifyUpdateMessage(final @NonNull Chat chat, final Message message) {
        this.iterateMessageListeners(chat, new MessageListenersVisitor(){

            @Override
            public void visit(ChatStoreService.MessageListener messageListener) {
                messageListener.afterUpdateMessage(chat, message);
            }

            @Override
            public String visitorName() {
                return "notifyUpdateMessage";
            }
        });
    }

    private void notifyBeforeMessagesRemoving(final @NonNull Chat chat, final List<Message> list) {
        this.iterateMessageListeners(chat, new MessageListenersVisitor(){

            @Override
            public void visit(ChatStoreService.MessageListener messageListener) {
                messageListener.beforeRemovingMessages(chat, list);
            }

            @Override
            public String visitorName() {
                return "notifyBeforeMessagesRemoving";
            }
        });
    }

    private void notifyAfterMessagesClear(final @NonNull Chat chat) {
        this.iterateMessageListeners(chat, new MessageListenersVisitor(){

            @Override
            public void visit(ChatStoreService.MessageListener messageListener) {
                messageListener.afterClearMessages(chat);
            }

            @Override
            public String visitorName() {
                return "notifyAfterMessagesClear";
            }
        });
    }

    @Override
    public void setChatFilter(ChatStoreService.Filter filter) {
        this.filter = filter;
    }

    public void beforeSendingMessage(final @NonNull Message message) {
        HMRContext.work.async("ChatStore::beforeSendingMessage", new Runnable(){

            @Override
            public void run() {
                if (ChatStoreServiceImpl.this.shouldIgnoreMessage(message)) {
                    return;
                }
                Chat chat = ChatStoreServiceImpl.this.setupConversationIfNeeded(message);
                if (chat == null) {
                    return;
                }
                ChatStoreServiceImpl.this.addOrUpdateMessage(chat, message, null);
                ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().create((Object)BeanMessage.fromMessage(message, System.currentTimeMillis()), BeanMessage.pendingConfig()));
            }
        });
    }

    public void onUpdateMessageState(@NonNull Message message, @NonNull Message.State state) {
        if (this.shouldIgnoreMessage(message)) {
            return;
        }
        if (state instanceof Preparing) {
            return;
        }
        Identifiable identifiable = message.getTarget();
        if (identifiable == null) {
            return;
        }
        Chat chat = this.getChat(identifiable);
        if (chat == null) {
            return;
        }
        this.addOrUpdateMessage(chat, message, null);
    }

    public void afterSendingMessage(final @NonNull Message message) {
        HMRContext.work.async("ChatStore::afterSendingMessage", new Runnable(){

            @Override
            public void run() {
                if (ChatStoreServiceImpl.this.shouldIgnoreMessage(message)) {
                    return;
                }
                ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().deleteById(BeanMessage.pendingConfig(), (Object)message.getUuid()));
            }
        });
    }

    public void beforeReceivingMessage(@NonNull Message message) {
    }

    public void afterReceivingMessage(final @NonNull Message message) {
        HMRContext.work.async("ChatStore::afterReceivingMessage", new Runnable(){

            @Override
            public void run() {
                if (ChatStoreServiceImpl.this.shouldIgnoreMessage(message)) {
                    return;
                }
                Chat chat = ChatStoreServiceImpl.this.setupConversationIfNeeded(message);
                if (chat == null) {
                    return;
                }
                ChatStoreServiceImpl.this.addOrUpdateMessage(chat, message, null);
            }
        });
    }

    private boolean shouldIgnoreMessage(@NonNull Message message) {
        return !this.filter.shouldAcceptMessage(message);
    }

    private Chat setupConversationIfNeeded(Message message) {
        Identifiable identifiable;
        if (message.getReceiver() instanceof AppSession) {
            Log.i((String)TAG, (Object)Trace.once().method("parseBroadCastAppSessionChatMessage").msg((Object)"setupConversationIfNeeded").info("receiver type", (Object)((AppSession)message.getReceiver()).getType()).info("id", (Object)((AppSession)message.getReceiver()).getId()));
        }
        if ((identifiable = message.getTarget()) == null) {
            return null;
        }
        Chat chat = this.getChat(identifiable);
        if (chat != null) {
            return chat;
        }
        final Chat chat2 = new Chat(identifiable, null, 0L, message, message.getTimestamp());
        this.chats.put(identifiable, chat2);
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().createTableIfNeeded(BeanMessage.conversationConfig(identifiable)).createIfNotExists((Object)BeanConversation.fromConversation(chat2), null).run("Hummer.Run.SetupConversationIfNeeded", new Runnable(){

            @Override
            public void run() {
                Log.w((String)ChatStoreServiceImpl.TAG, (Object)Trace.once().msg((Object)"Chat Created!"));
                ChatStoreServiceImpl.this.notifyAfterAddingConversation(chat2);
            }
        }));
        return chat2;
    }

    static interface MessageListenersVisitor {
        public void visit(ChatStoreService.MessageListener var1);

        public String visitorName();
    }
}

