/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import com.hummer.im._internals.shared.CodecManager;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class BeanMessage
implements Serializable {
    static final String FieldKey = "key";
    static final String FieldTimestamp = "ts";
    static final String FieldType = "type";
    static final String FieldContent = "content";
    static final String FieldDelFlag = "deleted";
    @DatabaseField(columnName="key", dataType=DataType.STRING, id=true)
    String key;
    @DatabaseField(columnName="ts", dataType=DataType.LONG, canBeNull=false)
    long ts;
    @DatabaseField(columnName="type", dataType=DataType.STRING, canBeNull=false)
    String type;
    @DatabaseField(columnName="content", dataType=DataType.STRING, canBeNull=false)
    String content;
    @DatabaseField(columnName="deleted", dataType=DataType.BOOLEAN, canBeNull=false)
    boolean deleted;
    public static final CodecManager<String, DBMessageData, Message> codecs = new CodecManager();

    public BeanMessage() {
    }

    private BeanMessage(String string, String string2, String string3, Long l) {
        this.content = string3;
        this.key = string;
        this.type = string2;
        this.deleted = false;
        if (l != null) {
            this.ts = l;
        }
    }

    public String toString() {
        return "BeanMessage{" + this.key + ", " + this.type + ", " + this.content + "}";
    }

    static DatabaseTableConfig<BeanMessage> conversationConfig(Identifiable identifiable) {
        DatabaseTableConfig databaseTableConfig = new DatabaseTableConfig();
        String string = "conversation_" + IDFactory.makeString((Identifiable)identifiable);
        databaseTableConfig.setTableName(string);
        databaseTableConfig.setDataClass(BeanMessage.class);
        return databaseTableConfig;
    }

    static DatabaseTableConfig<BeanMessage> pendingConfig() {
        DatabaseTableConfig databaseTableConfig = new DatabaseTableConfig();
        String string = "pending_chat_messages";
        databaseTableConfig.setTableName(string);
        databaseTableConfig.setDataClass(BeanMessage.class);
        return databaseTableConfig;
    }

    static Message toMessage(BeanMessage beanMessage) {
        return (Message)codecs.decode((Object)beanMessage.type, (Object)new DBMessageData(beanMessage.key, beanMessage.content));
    }

    static List<Message> toMessages(List<BeanMessage> list) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (BeanMessage beanMessage : list) {
            Message message = BeanMessage.toMessage(beanMessage);
            if (message == null) continue;
            arrayList.add(message);
        }
        return arrayList;
    }

    static List<BeanMessage> fromMessages(List<Message> list) {
        ArrayList<BeanMessage> arrayList = new ArrayList<BeanMessage>();
        for (Message message : list) {
            arrayList.add(BeanMessage.fromMessage(message, System.currentTimeMillis()));
        }
        return arrayList;
    }

    static BeanMessage fromMessage(Message message, Long l) {
        DBMessageData dBMessageData = (DBMessageData)codecs.encode((Object)message);
        return new BeanMessage(dBMessageData.key, (String)codecs.getDataType((Object)message), dBMessageData.content, l);
    }

    public static class DBMessageData {
        public final String key;
        public final String content;

        public DBMessageData(String string, String string2) {
            this.key = string;
            this.content = string2;
        }

        public String toString() {
            return "DBMessageData{" + this.key + ", " + this.content + "}";
        }
    }
}

