/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import com.hummer.im._internals.BeanConversation;
import com.hummer.im._internals.BeanMessage;
import com.hummer.im.db.DBService;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableUtils;
import java.sql.SQLException;
import java.util.List;

public final class ActFixConversationsIfNeeded
implements DBService.Action {
    public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
        List list;
        Dao dao = daoSet.create(null, BeanConversation.class);
        try {
            list = dao.queryForAll();
        }
        catch (SQLException sQLException) {
            return;
        }
        for (BeanConversation beanConversation : list) {
            if (beanConversation.name == null) continue;
            Identifiable identifiable = IDFactory.makeId((String)beanConversation.name);
            if (identifiable == null) {
                this.dropIllegalConversation(ormLiteSqliteOpenHelper, daoSet, beanConversation);
                continue;
            }
            this.recoverMissingMessageTable(ormLiteSqliteOpenHelper, daoSet, identifiable);
        }
    }

    private void recoverMissingMessageTable(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet, Identifiable identifiable) {
        DatabaseTableConfig<BeanMessage> databaseTableConfig = BeanMessage.conversationConfig(identifiable);
        try {
            Dao dao = daoSet.create(databaseTableConfig, null);
            dao.queryRaw("SELECT * FROM " + databaseTableConfig.getTableName() + " LIMIT 1", new String[0]);
        }
        catch (SQLException sQLException) {
            try {
                TableUtils.createTableIfNotExists((ConnectionSource)ormLiteSqliteOpenHelper.getConnectionSource(), databaseTableConfig);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            DaoManager.clearDaoCache();
        }
    }

    private void dropIllegalConversation(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet, BeanConversation beanConversation) {
        Dao dao;
        try {
            dao = daoSet.create(null, BeanConversation.class);
            dao.deleteById((Object)beanConversation.name);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            dao = new DatabaseTableConfig();
            String string = "conversation_" + beanConversation.name;
            dao.setTableName(string);
            dao.setDataClass(BeanMessage.class);
            TableUtils.dropTable((ConnectionSource)ormLiteSqliteOpenHelper.getConnectionSource(), (DatabaseTableConfig)dao, (boolean)true);
            DaoManager.clearDaoCache();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String toString() {
        return "Hummer.FixConversationsIfNeeded";
    }
}

