/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im._internals.shared.CodecManager;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@DatabaseTable(tableName="conversation_indexes")
public class BeanConversation
implements Serializable {
    static final String FieldName = "name";
    static final String FieldExtra = "extra";
    static final String FIELD_UNREAD_NUM = "unread_num";
    static final String FIELD_LATEST_MSG = "latest_msg";
    static final String FIELD_TIMESTAMP = "timestamp";
    static final String CODEC_TYPE_NAME = "chat_latest_message";
    @DatabaseField(id=true, columnName="name", unique=true)
    String name;
    @DatabaseField(columnName="extra")
    String extra;
    @DatabaseField(columnName="unread_num", dataType=DataType.LONG)
    long unreadNum;
    @DatabaseField(columnName="latest_msg", dataType=DataType.STRING, defaultValue="")
    String latestMsg;
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    long timestamp;
    public static final CodecManager<String, String, Message> codecs = new CodecManager();

    public BeanConversation() {
    }

    public BeanConversation(@NonNull String string, @Nullable String string2, long l, @NonNull String string3, long l2) {
        this.name = string;
        this.extra = string2;
        this.unreadNum = l;
        this.latestMsg = string3;
        this.timestamp = l2;
    }

    public String toString() {
        return "BeanConversation{" + this.name + "}";
    }

    static BeanConversation fromConversation(@NonNull Chat chat) {
        BeanConversation beanConversation = new BeanConversation();
        beanConversation.name = IDFactory.makeString((Identifiable)chat.getTarget());
        beanConversation.extra = chat.getExtra();
        beanConversation.unreadNum = chat.getUnreadNum();
        beanConversation.latestMsg = chat.getLatestMsg() != null ? (String)codecs.encode((Object)chat.getLatestMsg()) : "";
        beanConversation.timestamp = chat.getTimestamp();
        return beanConversation;
    }

    static Chat toConversation(@NonNull BeanConversation beanConversation) {
        Identifiable identifiable = IDFactory.makeId((String)beanConversation.name);
        Message message = null;
        if (beanConversation.latestMsg != null && beanConversation.latestMsg.length() > 0) {
            message = (Message)codecs.decode((Object)CODEC_TYPE_NAME, (Object)beanConversation.latestMsg);
        }
        return new Chat(identifiable, beanConversation.extra, beanConversation.unreadNum, message, beanConversation.timestamp);
    }

    static List<BeanConversation> fromConversations(@NonNull List<Chat> list) {
        ArrayList<BeanConversation> arrayList = new ArrayList<BeanConversation>();
        for (Chat chat : list) {
            arrayList.add(BeanConversation.fromConversation(chat));
        }
        return arrayList;
    }

    static List<Chat> toConversations(@NonNull List<BeanConversation> list) {
        ArrayList<Chat> arrayList = new ArrayList<Chat>();
        for (BeanConversation beanConversation : list) {
            arrayList.add(BeanConversation.toConversation(beanConversation));
        }
        return arrayList;
    }
}

