package com.hummer.im.model;

import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.service.ChatStoreService;


/**
 * 聊天会话模型类
 */
public final class Chat {

    /**
     * 构造一个会话实例
     * @param target 会话目标
     * @param extra  业务扩展数据
     */
    public Chat(Identifiable target, String extra, Long unreadNum, Message latestMsg, long timestamp) {
        this.target = target;
        this.extra = extra;
        this.unreadNum = unreadNum;
        this.latestMsg = latestMsg;
        this.timestamp = timestamp;
    }

    /**
     * 获取会话目标
     * <p>
     * 会话的目标类型可能是多样的，包括：
     * > User
     * 将来进行服务拓展时，还可能包括ChatRoom, SystemService等
     */
    public Identifiable getTarget() {
        return this.target;
    }

    /**
     * 设置业务扩展数据
     * <p>
     * 接入业务经常需要在会话对象中存放业务特定的数据，例如已读标记、会话草稿等。业务本可以自行持久化，但这会导致
     * 同一个会话，零散地在多处维护对应的数据。此外，也会增加业务的接入成本。因此，CIM为业务提供了一个扩展字段
     * 属性，该字段会被持久化到Hummer内部存储中。
     * <p>
     * 调用后可以通过 {@link ChatStoreService#updateChat} 来设置到数据库中
     */
    public void setExtra(String extra)  {
        this.extra = extra;
    }

    /**
     * 获取业务扩展数据
     * <p>
     * Extra的作用请参见{@link Chat#setExtra}的说明。需要强调的是，如何解析该数据，完全是业务决定的。
     */
    public String getExtra() {
        return extra;
    }

    public long getUnreadNum() {
        return unreadNum;
    }

    public void setUnreadNum(long unreadNum) {
        this.unreadNum = unreadNum;
    }

    public Message getLatestMsg() {
        return latestMsg;
    }

    public void setLatestMsg(Message latestMsg) {
        this.latestMsg = latestMsg;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        return "Chat{" + target + '}';
    }

    private final Identifiable target;
    private String extra;
    private long unreadNum;
    private Message latestMsg;
    private long timestamp;
}
