package com.hummer.im._internals;

import android.support.annotation.NonNull;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;

import java.lang.reflect.Constructor;
import java.util.Set;

public class ChatUtils {

    private static final String TAG = "ChatUtils";

    /**
     * 创建一个新的chat
     *
     * @return chat
     */
    static Chat newChat(@NonNull Identifiable target,
                        String extra,
                        Long unreadNum,
                        Message latestMsg,
                        long timestamp,
                        int priority,
                        @NonNull Set<String> tags) {

        Class<Chat> clazz = Chat.class;
        try {
            Constructor<Chat> constructor = clazz.getDeclaredConstructor(Identifiable.class,
                    String.class,
                    Long.class,
                    Message.class,
                    long.class,
                    int.class,
                    Set.class);
            constructor.setAccessible(true);
            return constructor.newInstance(target,
                    extra,
                    unreadNum,
                    latestMsg,
                    timestamp,
                    priority,
                    tags);
        } catch (Exception e) {
            Log.e(TAG, Trace.method("newChat")
                    .info("target", IDFactory.makeString(target))
                    .info("error", e.getMessage()));
            return null;
        }
    }
}
