package com.hummer.im._internals;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.db.DBService;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;

import org.json.JSONArray;
import org.json.JSONException;

import java.sql.SQLException;
import java.util.Locale;
import java.util.Set;

/**
 * 修改tags
 */
public class ActUpdateChatTag implements DBService.Action {

    private static final String SQL = "update conversation_indexes set %s = ? where name = ?";

    private Identifiable target;

    private Set<String> tagSet;

    ActUpdateChatTag(Identifiable target, Set<String> tagSet) {
        this.target = target;
        this.tagSet = tagSet;
    }

    @Override
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        Log.i(TAG, Trace.method("process").info("target", target.toString()).info("tag", tagSet));

        String tags;
        try {
            tags = new JSONArray(tagSet.toString()).toString();
        } catch (JSONException e) {
            Log.e(TAG, Trace.method("process").msg("tag to json error : " + e.getMessage()));
            tags = "[]";
        }

        String sql = String.format(Locale.US, SQL, BeanConversation.FIELD_TAGS);
        final Dao<BeanConversation, ?> dao = daoSet.create(null, BeanConversation.class);
        dao.updateRaw(sql, tags, IDFactory.makeString(target));
    }

    @Override
    public String toString() {
        return "ActUpdateChatTag | target: " + target.getId() + ", tags: " + tagSet;
    }

    private static final String TAG = "ActUpdateChatTag";
}
