package com.hummer.im._internals;

import android.support.annotation.NonNull;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.db.DBService;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;

import java.sql.SQLException;
import java.util.Locale;

/**
 * 修改priority
 */
public class ActUpdateChatPriority implements DBService.Action {

    private static final String SQL = "update conversation_indexes set %s = ? where name = ?";

    private Identifiable target;

    private int priority;

    ActUpdateChatPriority(@NonNull Identifiable target, int priority) {
        this.target = target;
        this.priority = priority;
    }

    @Override
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        Log.i(TAG, Trace.method("process").info("target", target.toString()).info("priority", priority));

        String sql = String.format(Locale.US, SQL, BeanConversation.FIELD_PRIORITY);
        final Dao<BeanConversation, ?> dao = daoSet.create(null, BeanConversation.class);
        dao.updateRaw(sql, priority + "", IDFactory.makeString(target));
    }

    @Override
    public String toString() {
        return "ActUpdateChatPriority | target: " + target.getId() + ", priority: " + priority;
    }

    private static final String TAG = "ActUpdateChatPriority";
}
