package com.hummer.im._internals;

import android.support.annotation.NonNull;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.IDFactory;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.table.DatabaseTableConfig;

import java.sql.SQLException;
import java.util.List;

public class ActUpdateChatLatestMsg implements DBService.Action {

    private static final String TAG = "ActUpdateChatLatestMsg";

    private Chat chat;

    ActUpdateChatLatestMsg(@NonNull Chat chat) {
        this.chat = chat;
    }

    @Override
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        if (chat == null) {
            Log.e(TAG, Trace.method("process").msg("chat is null"));
            return;
        }

        DatabaseTableConfig<BeanChatMessage> tableConfig
                = BeanChatMessage.chatMessageTableConfig(chat.getTarget());


        String condition = String.format("(%s = '%s' or %s = '%s')",
                BeanChatMessage.FIELD_SENDER,
                IDFactory.makeString(chat.getTarget()),
                BeanChatMessage.FIELD_RECEIVER,
                IDFactory.makeString(chat.getTarget()));

        QueryBuilder<BeanChatMessage, ?> queryBuilder = daoSet.create(tableConfig, null).queryBuilder();
        queryBuilder.where()
                .eq(BeanChatMessage.FIELD_DELETED, false)
                .and()
                .raw(condition);
        queryBuilder.orderBy(BeanChatMessage.FIELD_MSG_ID, false);
        queryBuilder.limit(1L);

        List<BeanChatMessage> beanMessageList = queryBuilder.query();
        if (beanMessageList.size() > 0) {
            Message message = BeanChatMessage.toMessage(beanMessageList.get(0));
            chat.setLatestMsg(message);
            chat.setTimestamp(message.getTimestamp());
        } else {
            chat.setLatestMsg(null);
        }

        // 更新最后一条消息
        Dao<BeanConversation, ?> conversationDao = daoSet.create(null, BeanConversation.class);
        conversationDao.update(BeanConversation.fromConversation(chat));
    }
}
