package com.hummer.im._internals;

import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.store.RemovingClauses;
import com.hummer.im.model.id.IDFactory;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.table.DatabaseTableConfig;

import java.sql.SQLException;
import java.util.Locale;

/**
 * 虽然语义上是"删除"，但在数据库中，并不会真正的移除消息记录，而是简单的将其deleted标记设为true
 */
public class ActRemoveMessages implements DBService.Action {

    private static final String TAG = "RemoveMessages";

    ActRemoveMessages(@NonNull Chat chat, @NonNull RemovingClauses clauses) {
        this.clauses = clauses;
        this.chat = chat;
    }

    @Override
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        Log.i(TAG, Trace.method("process").msg(chat.getTarget().toString()));

        final DatabaseTableConfig<BeanChatMessage> config
                = BeanChatMessage.chatMessageTableConfig(chat.getTarget());

        if (config.getTableName() == null) {
            Log.e("ActRemoveMessages", Trace.method("process")
                    .info("table name exception", null));
        }

        final Dao<BeanChatMessage, ?> dao = daoSet.create(config, BeanChatMessage.class);
        if (clauses.messages == null && clauses.uuids == null) {
            // update chat_message_? set deleted = 1 where sender = ? or receiver = ?;
            String stmt = String.format(Locale.US, "update %s set %s = 1 where %s = '%s' or %s = '%s'",
                    config.getTableName(),
                    BeanChatMessage.FIELD_DELETED,
                    BeanChatMessage.FIELD_SENDER,
                    IDFactory.makeString(chat.getTarget()),
                    BeanChatMessage.FIELD_RECEIVER,
                    IDFactory.makeString(chat.getTarget()));
            dao.updateRaw(stmt);
        } else {
            StringBuilder idSb = new StringBuilder();
            int i = 0;
            if (clauses.messages != null && clauses.messages.size() > 0) {
                for (Message message : clauses.messages) {
                    if (i++ > 0) {
                        idSb.append(",");
                    }
                    idSb.append("'").append(message.getUuid()).append("'");
                }
            }

            if (clauses.uuids != null && clauses.uuids.size() > 0) {
                for (String uuid : clauses.uuids) {
                    if (i++ > 0) {
                        idSb.append(",");
                    }
                    idSb.append("'").append(uuid).append("'");
                }
            }

            String ids = idSb.toString();
            if (TextUtils.isEmpty(ids)) {
                Log.w(TAG, Trace.method("process").msg("ids does not set"));
                return;
            }
            String stmt = String.format(Locale.US, "UPDATE %s SET %s = 1 WHERE %s IN (%s)",
                    config.getTableName(),
                    BeanChatMessage.FIELD_DELETED,
                    BeanChatMessage.FIELD_ID,
                    ids);
            dao.updateRaw(stmt);
        }
    }

    @Override
    public String toString() {
        return "Hummer.ActRemoveMessages "
                + "| chat: " + chat
                + ", clauses: " + clauses;
    }

    private final RemovingClauses clauses;
    private final Chat chat;
}
