package com.hummer.im._internals;

import android.support.annotation.NonNull;

import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.table.DatabaseTableConfig;

import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public class ActFetchMessagesByUuids implements DBService.Action {

    List<Message> messages;

    ActFetchMessagesByUuids(@NonNull Chat chat, @NonNull Set<String> uuids) {
        this.chat = chat;
        this.uuids = uuids;
    }

    @Override
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        DatabaseTableConfig<BeanChatMessage> tableConfig
                = BeanChatMessage.chatMessageTableConfig(chat.getTarget());

        Dao<BeanChatMessage, String> dao = (Dao<BeanChatMessage, String>) daoSet.create(tableConfig, null);

        List<BeanChatMessage> chatMessages
                = dao.queryBuilder().where().in(BeanChatMessage.FIELD_ID, uuids).query();
        messages = BeanChatMessage.toMessages(chatMessages);
    }

    private Chat chat;
    private Set<String> uuids;
}
