package com.hummer.im._internals;

import android.support.annotation.NonNull;

import com.hummer.im.HMR;
import com.hummer.im._internals.shared.statis.Util;
import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.store.FetchingClauses;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.User;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.table.DatabaseTableConfig;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class ActFetchMessages implements DBService.Action {

    List<Message> results;

    ActFetchMessages(@NonNull Chat chat, @NonNull FetchingClauses clauses) {
        this.chat = chat;
        this.clauses = clauses;
    }

    @Override
    @SuppressWarnings("unchecked")
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {

        // select * from chat_message_? where (sender = ? or receiver = ?) and rowId < ? order by rowId desc;
        // select * from chat_message_? where (sender = ? or receiver = ?) and timestamp <= ? order by rowId desc;

        DatabaseTableConfig<BeanChatMessage> tableConfig
                = BeanChatMessage.chatMessageTableConfig(chat.getTarget());
        Dao<BeanChatMessage, String> dao = (Dao<BeanChatMessage, String>) daoSet.create(tableConfig, null);
        QueryBuilder<BeanChatMessage, ?> queryBuilder = dao.queryBuilder();

        Where<BeanChatMessage, ?> where = queryBuilder.where();

        // 因为消息不会被真正移除，所以应过滤掉这些被标记为deleted的消息
        where.eq(BeanChatMessage.FIELD_DELETED, false);
        where.and();

        String condition;

        // 如果是自己给自己发消息：sender = 'user_a' and receiver = 'user_a'
        if (chat.getTarget().equals(HMR.getMe())) {
            condition = String.format("(%s = '%s' AND %s = '%s')",
                    BeanChatMessage.FIELD_SENDER,
                    IDFactory.makeString(chat.getTarget()),
                    BeanChatMessage.FIELD_RECEIVER,
                    IDFactory.makeString(chat.getTarget()));
        } else if (chat.getTarget() instanceof User) {
            // (receiver = user_a and sender = user_b) or (receiver = user_b and sender = user_a)
            condition = String.format("((%s = '%s' AND %s = '%s') OR (%s = '%s' AND %s = '%s'))",
                    BeanChatMessage.FIELD_SENDER,
                    IDFactory.makeString(chat.getTarget()),
                    BeanChatMessage.FIELD_RECEIVER,
                    IDFactory.makeString(HMR.getMe()),
                    BeanChatMessage.FIELD_SENDER,
                    IDFactory.makeString(HMR.getMe()),
                    BeanChatMessage.FIELD_RECEIVER,
                    IDFactory.makeString(chat.getTarget()));
        } else {
            // sender = group_c or receiver = group_c
            condition = String.format("(%s = '%s' OR %s = '%s')",
                    BeanChatMessage.FIELD_SENDER,
                    IDFactory.makeString(chat.getTarget()),
                    BeanChatMessage.FIELD_RECEIVER,
                    IDFactory.makeString(chat.getTarget()));
        }
        where.raw(condition);

        Long ts = clauses.getBeforeTimestamp();
        String uuid = clauses.getUuid();

        if (clauses.getBeforeMessage() != null) {
            if (ts == null) {
                ts = clauses.getBeforeMessage().getTimestamp();
            }
            if (uuid == null) {
                uuid = clauses.getBeforeMessage().getUuid();
            }
        }

        if (ts != null) {
            where.and();
            if (uuid != null) {
                where.lt(BeanChatMessage.FIELD_MSG_ID, Util.getMsgId(ts, uuid));
                // FIXME: 后面要看下为什么会出问题
                where.and().ne(BeanChatMessage.FIELD_ID, uuid);
            } else {
                where.le(BeanChatMessage.FIELD_TIMESTAMP, ts);
            }
        }

        if (clauses.getLimit() != null) {
            queryBuilder.limit(Long.valueOf(clauses.getLimit()));
        }

        queryBuilder.orderBy(BeanChatMessage.FIELD_MSG_ID, false);

        List<BeanChatMessage> dbMessages = queryBuilder.query();
        results = BeanChatMessage.toMessages(dbMessages);

        Collections.reverse(results);
    }

    @Override
    public String toString() {
        return "Hummer.FetchMessages "
                + "| chat: " + chat
                + ", clauses: " + clauses;
    }

    private final FetchingClauses clauses;
    private final Chat chat;

}
