package com.hummer.im._internals;

import com.hummer.im.db.DBService;
import com.hummer.im.model.Chat;
import com.hummer.im.model.chat.Message;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.table.DatabaseTableConfig;

import java.sql.SQLException;
import java.util.Locale;

public final class ActAddOrUpdateMessage implements DBService.Action {

    public interface Callback {
        void afterSaved(boolean isAdding);
    }

    ActAddOrUpdateMessage(Chat chat, Message message, Callback callback) {
        this.chat = chat;
        this.message = message;
        this.completion = callback;
    }

    @Override
    @SuppressWarnings("unchecked")
    public void process(OrmLiteSqliteOpenHelper helper, DBService.DaoSet daoSet) throws SQLException {
        BeanChatMessage dbMessage = BeanChatMessage.fromMessage(message);
        DatabaseTableConfig<BeanChatMessage> tableConfig
                = BeanChatMessage.chatMessageTableConfig(chat.getTarget());

        Dao<BeanChatMessage, String> dao = (Dao<BeanChatMessage, String>) daoSet.create(tableConfig, null);

        boolean notExisted = !dao.idExists(dbMessage.id);

        if (notExisted) {
            dao.create(dbMessage);
            completion.afterSaved(true);
        } else {
            // update chat_message_? set timestamp = ?, state = ?, kv_extra = ?, app_extra = ?,
            // push_content = ?, content = ?, new_content = ?, msg_id = ? where id = ?
            String stmt = String.format(Locale.US,
                    UPDATE_SQL,
                    tableConfig.getTableName(),
                    BeanChatMessage.FIELD_TIMESTAMP,
                    BeanChatMessage.FIELD_STATE,
                    BeanChatMessage.FIELD_KV_EXTRA,
                    BeanChatMessage.FIELD_APP_EXTRA,
                    BeanChatMessage.FIELD_PUSH_CONTENT,
                    BeanChatMessage.FIELD_CONTENT,
                    BeanChatMessage.FIELD_NEW_CONTENT,
                    BeanChatMessage.FIELD_MSG_ID,
                    BeanChatMessage.FIELD_ID);

            daoSet.create(tableConfig, null).updateRaw(stmt,
                    dbMessage.timestamp + "",
                    dbMessage.state,
                    dbMessage.kvExtra,
                    dbMessage.appExtra,
                    dbMessage.pushContent,
                    dbMessage.content,
                    dbMessage.newContent,
                    dbMessage.msgId,
                    dbMessage.id);
            completion.afterSaved(false);
        }
    }

    @Override
    public String toString() {
        return "Hummer.ActAddOrUpdateMessage "
                + "| chat: " + chat
                + ", message: " + message;
    }

    private final Message message;
    private final Chat chat;
    private final Callback completion;

    private static final String UPDATE_SQL
            = "update %s set %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ?, %s = ? where %s = ?";
}
