/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RPCPullAllAdminUser
extends ChatRoomRPC<ChatRoomProto.PCS_ChatRoomManagerRes> {
    private final RichCompletionArg<Map<String, List<User>>> mCompletion;
    private final int roomid;
    private final String role;

    public RPCPullAllAdminUser(int n, String string, RichCompletionArg<Map<String, List<User>>> richCompletionArg) {
        this.roomid = n;
        this.role = string;
        this.mCompletion = richCompletionArg;
    }

    public String getFunctionName() {
        return "GetChatRoomManager";
    }

    public String getChatroomServiceName() {
        return "chatroom_smember";
    }

    public Marshallable requestObj() {
        ChatRoomProto.PCS_ChatRoomManagerReq pCS_ChatRoomManagerReq = new ChatRoomProto.PCS_ChatRoomManagerReq();
        pCS_ChatRoomManagerReq.roomId = Uint32.toUInt((int)this.roomid);
        pCS_ChatRoomManagerReq.appkey = Uint32.toUInt((long)HMRContext.appId);
        pCS_ChatRoomManagerReq.role = this.role;
        return pCS_ChatRoomManagerReq;
    }

    public void handleSuccess(@NonNull ChatRoomProto.PCS_ChatRoomManagerRes pCS_ChatRoomManagerRes) {
        HashMap hashMap = new HashMap();
        if (pCS_ChatRoomManagerRes.admins.size() > 0) {
            for (Map.Entry<String, ArrayList<Uint64>> entry : pCS_ChatRoomManagerRes.admins.entrySet()) {
                String string = entry.getKey();
                ArrayList<User> arrayList = new ArrayList<User>();
                List list = pCS_ChatRoomManagerRes.admins.get(string);
                for (Uint64 uint64 : list) {
                    User user = new User(uint64.longValue());
                    arrayList.add(user);
                }
                hashMap.put(string, arrayList);
            }
        }
        CompletionUtils.dispatchSuccess(this.mCompletion, hashMap);
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure(this.mCompletion, (Error)error);
    }
}

