package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.CompletionUtils;


public class RPCLeaveChatRoom extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public RPCLeaveChatRoom(int roomId, RichCompletion completion) {
        this.roomId = roomId;
        this.mCompletion = completion;
    }

    @Override
    public String getFunctionName() {
        return "LeaveChatRoom";
    }

    @Override
    public String getChatroomServiceName() {
        return "chatroom_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_LeaveChatRoomReq req = new ChatRoomProto.PCS_LeaveChatRoomReq();
        req.appkey = Uint32.toUInt(HMRContext.appId);
        req.roomid = Uint32.toUInt(roomId);
        req.uid = Uint64.toUInt(HMR.getMe().getId());
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res res) {
        Log.i("RPCLeaveChatRoom", Trace.once().method("dispatchSuccess")
                .msg("leave chat room"));
        CompletionUtils.dispatchSuccess(mCompletion);
    }

    @Override
    public void handleError(@NonNull Error err) {
        Log.i("RPCLeaveChatRoom", Trace.once().method("dispatchFailure")
                .info("result", err.toString()));
        CompletionUtils.dispatchFailure(mCompletion, err);
    }

    private final RichCompletion mCompletion;
    private final int roomId;
}
