package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.CompletionUtils;


public class RPCChangeChatRoomRole extends
        ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {

    public RPCChangeChatRoomRole(long roomid, long uid, ChatRoomProto.AdminRoleTypeEnum roler,
                                 ChatRoomProto.ChatRoomOpEnum op,
                                 RichCompletion completion) {
        this.roomid = roomid;
        this.uid = uid;
        this.op = op;
        this.roler = roler;
        this.mCompletion = completion;
    }

    @Override
    public String getFunctionName() {
        return "UpdateRoler";
    }

    @Override
    public String getChatroomServiceName() {
        return "chatroom_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_UpdateChatRoomRolerReq req = new ChatRoomProto.PCS_UpdateChatRoomRolerReq();
        req.appkey = Uint32.toUInt(HMRContext.appId);
        req.roomid = Uint32.toUInt(roomid);
        req.admin = Uint64.toUInt(HMR.getMe().getId());
        req.uid = Uint64.toUInt(uid);
        req.op = Uint32.toUInt(op.ordinal());
        req.roler = roler.getCode();
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res res) {
        CompletionUtils.dispatchSuccess(mCompletion);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(mCompletion, err);
    }

    private final RichCompletion mCompletion;

    private final long roomid;
    private final long uid;
    private final ChatRoomProto.ChatRoomOpEnum op;
    private final ChatRoomProto.AdminRoleTypeEnum roler;
}
