/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom.ChatRoomService;
import com.hummer.im.chatroom._internals.ChatRoomServiceImpl;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.id.ChatRoom;
import com.hummer.im.service.Channel;
import java.util.HashMap;

public class RPCSendBroadcast
extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public static final String TAG = "RPCSendBroadcast";
    private final Message message;
    private final RichCompletion completion;

    public RPCSendBroadcast(Message message, RichCompletion richCompletion) {
        this.message = message;
        this.completion = richCompletion;
    }

    public Marshallable requestObj() {
        ChatRoom chatRoom = (ChatRoom)this.message.getReceiver();
        ChatRoomService.Signal signal = (ChatRoomService.Signal)this.message.getContent();
        ChatRoomProto.PCS_SendBroadcastReq pCS_SendBroadcastReq = new ChatRoomProto.PCS_SendBroadcastReq();
        pCS_SendBroadcastReq.appKey = Uint32.toUInt((long)HMRContext.getAppId());
        pCS_SendBroadcastReq.roomId = Uint32.toUInt((long)chatRoom.getId());
        pCS_SendBroadcastReq.uid = Uint64.toUInt((long)HMR.getMe().getId());
        pCS_SendBroadcastReq.content = signal.content;
        pCS_SendBroadcastReq.requestId = this.message.getUuid();
        pCS_SendBroadcastReq.timestamp = Uint64.toUInt((long)((Channel)HMR.getService(Channel.class)).getAlignmentServerTS());
        if (!TextUtils.isEmpty((CharSequence)this.message.getAppExtra())) {
            HashMap<String, String> hashMap = new HashMap<String, String>(1, 1.0f);
            hashMap.put("hmr_extra_key", this.message.getAppExtra());
            pCS_SendBroadcastReq.extraMap = hashMap;
        }
        return pCS_SendBroadcastReq;
    }

    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res pCS_CommonOperatorAuth2Res) {
        CompletionUtils.dispatchSuccess((RichCompletion)this.completion);
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure((RichCompletion)this.completion, (Error)error);
    }

    public String getFunctionName() {
        return "SendBroadcast";
    }

    public String getServiceName() {
        return ChatRoomServiceImpl.getServiceName("chatroom_auther");
    }
}

