/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom.Challenges;
import com.hummer.im.chatroom._internals.ChallengeImpl;
import com.hummer.im.chatroom._internals.ChatRoomServiceImpl;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import java.util.Map;

public final class RPCJoinChatRoom
extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    private Challenges.JoiningCompletionArg<Map<String, String>> authCompletion = null;
    private Map<String, String> joinProps;
    private boolean bTwice;
    private String password;
    private RichCompletion completion;
    private int roomId;

    public RPCJoinChatRoom(int n, Map<String, String> map, Challenges.JoiningCompletionArg<Map<String, String>> joiningCompletionArg) {
        this.roomId = n;
        this.joinProps = map;
        this.authCompletion = joiningCompletionArg;
        this.bTwice = false;
        this.password = "";
        this.completion = null;
    }

    public RPCJoinChatRoom(int n, String string, Map<String, String> map, RichCompletion richCompletion) {
        this.roomId = n;
        this.joinProps = map;
        this.password = string;
        this.completion = richCompletion;
        this.bTwice = true;
    }

    public String getFunctionName() {
        return "JoinChatRoom";
    }

    public String getServiceName() {
        return ChatRoomServiceImpl.getServiceName("chatroom_auther");
    }

    public Marshallable requestObj() {
        ChatRoomProto.PCS_JoinChatRoomReq pCS_JoinChatRoomReq = new ChatRoomProto.PCS_JoinChatRoomReq();
        pCS_JoinChatRoomReq.appkey = Uint32.toUInt((long)HMRContext.appId);
        pCS_JoinChatRoomReq.roomid = Uint32.toUInt((int)this.roomId);
        pCS_JoinChatRoomReq.uid = Uint64.toUInt((long)HMR.getMe().getId());
        pCS_JoinChatRoomReq.joinProps = this.joinProps;
        return pCS_JoinChatRoomReq;
    }

    public void handleSuccess(final @NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res pCS_CommonOperatorAuth2Res) {
        HMRContext.work.async("RPCJoinChatRoom::handleSuccess", new Runnable(){

            @Override
            public void run() {
                if (RPCJoinChatRoom.this.authCompletion != null) {
                    RPCJoinChatRoom.this.authCompletion.onSucceed(pCS_CommonOperatorAuth2Res.props);
                }
            }
        });
    }

    public void handleError(@Nullable ChatRoomProto.PCS_CommonOperatorAuth2Res pCS_CommonOperatorAuth2Res, final @NonNull Error error) {
        if (pCS_CommonOperatorAuth2Res == null) {
            Log.e((String)"RPCJoinChatRoom", (Object)Trace.once().method("handleError").info("res", null));
        }
        if (pCS_CommonOperatorAuth2Res.res.intValue() == 0) {
            return;
        }
        if (pCS_CommonOperatorAuth2Res.res.intValue() == 3006) {
            if (!this.bTwice) {
                final ChallengeImpl.PasswordImpl passwordImpl = new ChallengeImpl.PasswordImpl(pCS_CommonOperatorAuth2Res.roomId.longValue());
                HMRContext.work.async("RPCJoinChatRoom::handleChallengeException", new Runnable(){

                    @Override
                    public void run() {
                        if (RPCJoinChatRoom.this.authCompletion != null) {
                            RPCJoinChatRoom.this.authCompletion.onReceiveChallenge(passwordImpl);
                        }
                    }
                });
            } else {
                CompletionUtils.dispatchFailure((RichCompletion)this.completion, (Error)error);
            }
        } else if (!this.bTwice) {
            HMRContext.work.async("RPCJoinChatRoom::handleauthCompletion", new Runnable(){

                @Override
                public void run() {
                    if (RPCJoinChatRoom.this.authCompletion != null) {
                        RPCJoinChatRoom.this.authCompletion.onFailure(error);
                    }
                }
            });
        } else {
            CompletionUtils.dispatchFailure((RichCompletion)this.completion, (Error)error);
        }
    }

    public void handleError(final @NonNull Error error) {
        if (!this.bTwice) {
            HMRContext.work.async("RPCJoinChatRoom::handleError", new Runnable(){

                @Override
                public void run() {
                    if (RPCJoinChatRoom.this.authCompletion != null) {
                        RPCJoinChatRoom.this.authCompletion.onFailure(error);
                    }
                }
            });
        } else {
            CompletionUtils.dispatchFailure((RichCompletion)this.completion, (Error)error);
        }
    }
}

