/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom._internals.ChatRoomServiceImpl;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.User;
import java.util.HashMap;
import java.util.Map;

public class RPCFetchOnlineUserInfoList
extends ChatRoomRPC<ChatRoomProto.PCS_OnlineUserInfoListRes> {
    private long roomId;
    private RichCompletionArg<Map<User, Map<String, String>>> completion;

    public RPCFetchOnlineUserInfoList(long l, RichCompletionArg<Map<User, Map<String, String>>> richCompletionArg) {
        this.roomId = l;
        this.completion = richCompletionArg;
    }

    public String getServiceName() {
        return ChatRoomServiceImpl.getServiceName("chatroom_online_query_d");
    }

    public String getFunctionName() {
        return "GetUserInfoList";
    }

    public Marshallable requestObj() {
        ChatRoomProto.PCS_OnlineUserInfoListReq pCS_OnlineUserInfoListReq = new ChatRoomProto.PCS_OnlineUserInfoListReq();
        pCS_OnlineUserInfoListReq.appid = Uint32.toUInt((long)HMRContext.appId);
        pCS_OnlineUserInfoListReq.roomid = Uint32.toUInt((long)this.roomId);
        return pCS_OnlineUserInfoListReq;
    }

    public void handleSuccess(@NonNull ChatRoomProto.PCS_OnlineUserInfoListRes pCS_OnlineUserInfoListRes) {
        HashMap<User, Map<String, String>> hashMap = new HashMap<User, Map<String, String>>(pCS_OnlineUserInfoListRes.userInfos.size());
        for (Map.Entry<Uint64, Map<String, String>> entry : pCS_OnlineUserInfoListRes.userInfos.entrySet()) {
            hashMap.put(new User(entry.getKey().longValue()), entry.getValue());
        }
        CompletionUtils.dispatchSuccess(this.completion, hashMap);
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, (Error)error);
    }
}

