/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.chatroom._internals.ChatRoomServiceImpl;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;

public class RPCFetchChatRoomInfo
extends ChatRoomRPC<ChatRoomProto.PCS_ChatRoomInfoRes> {
    private final RichCompletionArg<ChatRoomInfo> mCompletion;
    private final int roomId;

    public RPCFetchChatRoomInfo(int n, RichCompletionArg<ChatRoomInfo> richCompletionArg) {
        this.roomId = n;
        this.mCompletion = richCompletionArg;
    }

    public String getFunctionName() {
        return "GetChatRoomInfo";
    }

    public String getServiceName() {
        return ChatRoomServiceImpl.getServiceName("chatroom_sinfo");
    }

    public Marshallable requestObj() {
        ChatRoomProto.PCS_ChatRoomInfoReq pCS_ChatRoomInfoReq = new ChatRoomProto.PCS_ChatRoomInfoReq();
        pCS_ChatRoomInfoReq.appkey = Uint32.toUInt((long)HMRContext.appId);
        pCS_ChatRoomInfoReq.roomId = Uint32.toUInt((int)this.roomId);
        return pCS_ChatRoomInfoReq;
    }

    public void handleSuccess(@NonNull ChatRoomProto.PCS_ChatRoomInfoRes pCS_ChatRoomInfoRes) {
        String string = pCS_ChatRoomInfoRes.props.containsKey(ChatRoomInfo.BasicInfoType.Name.name()) ? pCS_ChatRoomInfoRes.props.get(ChatRoomInfo.BasicInfoType.Name.name()) : "";
        String string2 = pCS_ChatRoomInfoRes.props.containsKey(ChatRoomInfo.BasicInfoType.Description.name()) ? pCS_ChatRoomInfoRes.props.get(ChatRoomInfo.BasicInfoType.Description.name()) : "";
        String string3 = pCS_ChatRoomInfoRes.props.containsKey(ChatRoomInfo.BasicInfoType.Bulletin.name()) ? pCS_ChatRoomInfoRes.props.get(ChatRoomInfo.BasicInfoType.Bulletin.name()) : "";
        String string4 = pCS_ChatRoomInfoRes.props.containsKey(ChatRoomInfo.BasicInfoType.AppExtra.name()) ? pCS_ChatRoomInfoRes.props.get(ChatRoomInfo.BasicInfoType.AppExtra.name()) : "";
        ChatRoomInfo chatRoomInfo = new ChatRoomInfo(string, string2, string3, string4);
        Log.i((String)"RPCFetchChatRoomInfo", (Object)Trace.once().method("dispatchSuccess").info("result", (Object)chatRoomInfo.toString()));
        CompletionUtils.dispatchSuccess(this.mCompletion, (Object)chatRoomInfo);
    }

    public void handleError(@NonNull Error error) {
        Log.i((String)"RPCFetchChatRoomInfo", (Object)Trace.once().method("dispatchFailure").info("result", (Object)error.toString()));
        CompletionUtils.dispatchFailure(this.mCompletion, (Error)error);
    }
}

