/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.chatsvc.ChatServiceImpl;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.Source;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.services.mq.StatisticsReporter;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Receiver;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.chatroom.Challenges;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.chatroom.ChatRoomService;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.RPCChangeChatRoomInfo;
import com.hummer.im.chatroom._internals.rpc.RPCChangeChatRoomRole;
import com.hummer.im.chatroom._internals.rpc.RPCChatRoomTextChat;
import com.hummer.im.chatroom._internals.rpc.RPCCreateChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCDeleteUserInfo;
import com.hummer.im.chatroom._internals.rpc.RPCDisableUserText;
import com.hummer.im.chatroom._internals.rpc.RPCDismissChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCFetchAdminList;
import com.hummer.im.chatroom._internals.rpc.RPCFetchChatRoomInfo;
import com.hummer.im.chatroom._internals.rpc.RPCFetchMemberList;
import com.hummer.im.chatroom._internals.rpc.RPCFetchMutedMemberList;
import com.hummer.im.chatroom._internals.rpc.RPCFetchOnlineUserInfoList;
import com.hummer.im.chatroom._internals.rpc.RPCFetchUserInfo;
import com.hummer.im.chatroom._internals.rpc.RPCJoinChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCKickOffUser;
import com.hummer.im.chatroom._internals.rpc.RPCLeaveChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCPingChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCPullAllAdminUser;
import com.hummer.im.chatroom._internals.rpc.RPCSendBroadcast;
import com.hummer.im.chatroom._internals.rpc.RPCSendUnicast;
import com.hummer.im.chatroom._internals.rpc.RPCSetUserInfo;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.contents.Text;
import com.hummer.im.model.chat.states.Archived;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccess;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.ChatRoom;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im.service.Channel;
import com.hummer.im.service.MQService;
import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.YYServiceCore;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTask;
import com.yy.platform.baseservice.utils.UserGroupType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;

public class ChatRoomServiceImpl
implements ServiceProvider.Service,
ChatRoomService,
Channel.StateChangedListener {
    private static long kRejoinConditionGap = 60000L;
    private static final int kickTimeSec = 300;
    private static final String TAG = "ChatRoomService";
    private static final long onlineBCGrpType = 0x80000002L;
    private static final long authBCGrpType = 0x80000001L;
    private static final long textChatBCGrpType = 0x80000000L;
    private static final int MUTED_TIME_SEC = 259200;
    private static final long kReferenceValue = 946656000L;
    private long mInitialTimeInterval = 0L;
    private static final String OFFLINE_DURATION_KEY = "props_offline_check_duration";
    private static final String NEED_PING_KEY = "props_need_ping";
    private static final String NEED_PING_VALUE = "1";
    private static final String COMMON_RES_PROPS_CROSS_REGION_HEARTBEAT_DURATION = "props_cross_region_heartbeat_duration";
    private static String region;
    private final CopyOnWriteArraySet<ChatRoom> pingChatRooms = new CopyOnWriteArraySet();
    private final Set<ChatRoomService.MemberListener> memberListeners = new HashSet<ChatRoomService.MemberListener>();
    private final Set<ChatRoomService.ChatRoomListener> listeners = new HashSet<ChatRoomService.ChatRoomListener>();
    private final Set<ChatRoom> chatRooms = new HashSet<ChatRoom>();
    private Timer keepAliveTimer = null;
    private TimerTask keepAliveTimerTask;
    private static int keepAliveInterval;

    public Class[] staticDependencies() {
        return new Class[]{Channel.class};
    }

    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class, Channel.class};
    }

    public Class[] plantingDynamicDependencies() {
        return null;
    }

    public void initService() {
        this.registerChatServiceExtensions();
        this.registerReporterExtensions();
    }

    public void openService(@NonNull RichCompletion richCompletion) {
        ((Channel)HMR.getService(Channel.class)).addStateListener((Channel.StateChangedListener)this);
        CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
    }

    public void closeService() {
        if (this.chatRooms.size() > 0) {
            for (ChatRoom chatRoom : this.chatRooms) {
                Log.i((String)TAG, (Object)String.format(Locale.US, "leave chatRoom after closeService, roomId:%d", chatRoom.getId()));
                this.leaveChatRoom(chatRoom, false, null);
            }
            this.chatRooms.clear();
        }
        ((Channel)HMR.getService(Channel.class)).removeStateListener((Channel.StateChangedListener)this);
        this.resetInitialTimeInterval();
        this.resetDuration();
    }

    private void registerReporterExtensions() {
        StatisticsReporter.registerReporterExtension((StatisticsReporter.ReporterExtension)new StatisticsReporter.ReporterExtension(){

            public Integer parseReportType(Message message) {
                if (message.getContent() instanceof ChatRoomService.Signal) {
                    ChatRoomService.Signal signal = (ChatRoomService.Signal)message.getContent();
                    if (signal.user != null) {
                        return StatisticsReporter.ReliableType.Reliable;
                    }
                }
                return null;
            }
        });
        StatisticsReporter.registerReceiverExtension((StatisticsReporter.ReceiverExtension)new StatisticsReporter.ReceiverExtension(){

            public Long parseReceiver(Message message) {
                if (message.getContent() instanceof ChatRoomService.Signal) {
                    ChatRoomService.Signal signal = (ChatRoomService.Signal)message.getContent();
                    if (signal.user != null) {
                        return signal.user.getId();
                    }
                }
                return null;
            }
        });
    }

    private void registerChatServiceExtensions() {
        ChatServiceImpl.registerSendingExtension((ChatServiceImpl.SendingExtension)new ChatServiceImpl.SendingExtension(){

            public Channel.RPC makeSendingRPC(final Message message, RichCompletion richCompletion) {
                if (!(message.getSender() instanceof User) || !(message.getReceiver() instanceof ChatRoom)) {
                    return null;
                }
                ChatRoom chatRoom = (ChatRoom)message.getReceiver();
                if (message.getContent() instanceof Text) {
                    return new RPCChatRoomTextChat(chatRoom.getId(), ((Text)message.getContent()).getText(), (Map<String, String>)new HashMap<String, String>(){
                        {
                            this.put("uuid", message.getUuid());
                            if (message.getAppExtra() != null) {
                                this.put("extra", message.getAppExtra());
                            }
                        }
                    }, null, richCompletion);
                }
                if (message.getContent() instanceof ChatRoomService.Signal) {
                    ChatRoomService.Signal signal = (ChatRoomService.Signal)message.getContent();
                    if (signal.user == null) {
                        return new RPCSendBroadcast(message, richCompletion);
                    }
                    return new RPCSendUnicast(message, richCompletion);
                }
                return null;
            }
        });
        ChatServiceImpl.registerParserExtension((ChatServiceImpl.ParserExtension)new ChatServiceImpl.ParserExtension(){

            public String toString() {
                return "ChatRoom";
            }

            public Message parseMessage(String string, String string2, byte[] byArray) {
                try {
                    if ("chatroom_textchat".equals(string) && "TextChatBc".equals(string2)) {
                        return ChatRoomServiceImpl.this.handleTextMessage(byArray);
                    }
                    if ("chatroom_auther".equals(string) && "UpdateChatRoomInfoBc".equals(string2)) {
                        ChatRoomServiceImpl.this.handleBasicInfoChanged(byArray);
                    } else if ("chatroom_auther".equals(string) && "UpdateRolerBc".equals(string2)) {
                        ChatRoomServiceImpl.this.handleMemberRoleChanged(byArray);
                    } else if ("chatroom_auther".equals(string) && "KickOffUserBc".equals(string2)) {
                        ChatRoomServiceImpl.this.handleMemberKicked(byArray);
                    } else if ("chatroom_auther".equals(string) && "DismissChatRoomBc".equals(string2)) {
                        ChatRoomServiceImpl.this.handleChatRoomDeleted(byArray);
                    } else if ("chatroom_auther".equals(string) && "DisableUserTextBc".equals(string2)) {
                        ChatRoomServiceImpl.this.handleChatMutation(byArray);
                    } else if ("chatroom_auther".equals(string) && "UserInfoChangeBc".equals(string2)) {
                        ChatRoomServiceImpl.this.handleUserInfoChanged(byArray);
                    }
                }
                catch (Throwable throwable) {
                    Log.e((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("parseMessage").info("function", (Object)string2).info("service", (Object)string).info("exception", (Object)throwable.getMessage()));
                }
                return null;
            }

            public Message parseMessage(Im.Msg msg, Source source) {
                try {
                    if (msg.getAction() == 1200001) {
                        return ChatRoomServiceImpl.this.handleUnicastMessage(msg.getContent().toByteArray());
                    }
                    if (msg.getAction() == 1250005) {
                        return ChatRoomServiceImpl.this.handleBroadcastMessage(msg.getContent().toByteArray());
                    }
                    if (msg.getAction() == 1270001) {
                        ChatRoomServiceImpl.this.handleUserCountChanged(msg.getContent().toByteArray());
                    } else if (msg.getAction() == 1270002) {
                        ChatRoomServiceImpl.this.handleMembersChanged(msg.getContent().toByteArray());
                    }
                    source.checkIntegrity(msg);
                }
                catch (Throwable throwable) {
                    Log.e((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("parse").info("action", (Object)msg.getAction()).info("msg", (Object)msg.getContent()).info("exception", (Object)throwable.getMessage()));
                }
                return null;
            }
        });
    }

    private String getSharedTopic(String string) {
        return String.format(Locale.US, "ChatRoom/%s/%s", String.valueOf(HMRContext.appId), string);
    }

    private String getPrivatedTopic() {
        return String.format(Locale.US, "ChatRoom/%s", String.valueOf(HMRContext.appId));
    }

    @Override
    public void setRegion(String string) {
        region = string.toLowerCase(Locale.US);
    }

    public static String getRegion() {
        if (!TextUtils.isEmpty((CharSequence)region)) {
            return region;
        }
        if (HMRContext.region != null) {
            return HMRContext.region.area;
        }
        return "cn";
    }

    @Override
    public void createChatRoom(@NonNull ChatRoomInfo chatRoomInfo, @NonNull HMR.CompletionArg<ChatRoom> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "CHatRoomService::createChatRoom");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"createChatRoom subject:%s", (Object[])new Object[]{chatRoomInfo.getName()}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCCreateChatRoom(chatRoomInfo, (RichCompletionArg<ChatRoom>)richCompletionArg));
    }

    @Override
    public void dismissChatRoom(@NonNull ChatRoom chatRoom, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::dismissChatRoom");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"deleteChatRoom chatRoom: %s", (Object[])new Object[]{chatRoom.getId()}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCDismissChatRoom(Long.valueOf(chatRoom.getId()).intValue(), richCompletion));
    }

    private void handleAppExtras(ChatRoom chatRoom, Map<String, String> map) {
        String string;
        Log.i((String)TAG, (Object)("handleAppExtras: " + map));
        String string2 = map.get(OFFLINE_DURATION_KEY);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                kRejoinConditionGap = (Long.valueOf(string2) - 5L) * 1000L;
            }
            catch (Exception exception) {
                Log.e((String)TAG, (Object)String.format(Locale.US, "[%s] Parse offline duration exception!", string2));
            }
        }
        if (NEED_PING_VALUE.equals(string = map.get(NEED_PING_KEY))) {
            String string3 = map.get(COMMON_RES_PROPS_CROSS_REGION_HEARTBEAT_DURATION);
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                try {
                    int n = Integer.parseInt(string3);
                    this.updateDuration(n);
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (Object)String.format(Locale.US, "[%s] Parse duration exception!", string3));
                }
            }
            this.addPingChatRoom(chatRoom);
        }
    }

    @Override
    public void join(final @NonNull ChatRoom chatRoom, final @NonNull Map<String, String> map, final @NonNull Challenges.JoiningCompletion joiningCompletion) {
        Log.i((String)TAG, (Object)Trace.once((String)"join chatRoom: %s", (Object[])new Object[]{chatRoom.getId()}));
        if (HMR.getState() != HMR.State.Opened) {
            DispatchQueue.main.async("ChatRoomService::joinFailCallback", new Runnable(){

                @Override
                public void run() {
                    joiningCompletion.onFailure(new Error(1011, "User not login"));
                }
            });
            return;
        }
        if (HMR.getMe().isAnonymous()) {
            HMRContext.work.async("ChatRoomService::subscribe", new Runnable(){

                @Override
                public void run() {
                    ChatRoomServiceImpl.this._subscribeChatRoomBC(chatRoom, new RichCompletion("ChatRoomService::subscribe").onSuccess(new OnSuccess(){

                        public void onSuccess() {
                            ChatRoomServiceImpl.this.addChatRoom(chatRoom);
                            DispatchQueue.main.async("ChatRoomService::subscribeSuccessCallback", new Runnable(){

                                @Override
                                public void run() {
                                    joiningCompletion.onSucceed();
                                }
                            });
                        }
                    }).onFailure(new OnFailure(){

                        public void onFailure(final Error error) {
                            DispatchQueue.main.async("ChatRoomService::subscribeFailureCallback", new Runnable(){

                                @Override
                                public void run() {
                                    joiningCompletion.onFailure(error);
                                }
                            });
                        }
                    }));
                }
            });
        } else {
            HMRContext.work.async("ChatRoomService::join", new Runnable(){

                @Override
                public void run() {
                    ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCJoinChatRoom((int)chatRoom.getId(), map, new Challenges.JoiningCompletionArg<Map<String, String>>(){

                        @Override
                        public void onReceiveChallenge(final Challenges.Password password) {
                            DispatchQueue.main.async("ChatRoomService::onReceiveChallengePassword", new Runnable(){

                                @Override
                                public void run() {
                                    joiningCompletion.onReceiveChallenge(password);
                                }
                            });
                        }

                        @Override
                        public void onReceiveChallenge(final Challenges.AppChallenge appChallenge) {
                            DispatchQueue.main.async("ChatRoomService::onReceiveChallengeAppChallenge", new Runnable(){

                                @Override
                                public void run() {
                                    joiningCompletion.onReceiveChallenge(appChallenge);
                                }
                            });
                        }

                        @Override
                        public void onSucceed(Map<String, String> map) {
                            Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("joinChatRoomDone").info("id", (Object)chatRoom.getId()).info("props", map));
                            ChatRoomServiceImpl.this.handleJoinChatRoom(chatRoom);
                            ChatRoomServiceImpl.this.handleAppExtras(chatRoom, map);
                            Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("handleAppExtrasDone").info("rejoinConditionGap", (Object)kRejoinConditionGap));
                            ChatRoomServiceImpl.this.addChatRoom(chatRoom);
                            ChatRoomServiceImpl.this._subscribeChatRoomBC(chatRoom, new RichCompletion("ChatRoomService::joinSuccess").onSuccess(new OnSuccess(){

                                public void onSuccess() {
                                    DispatchQueue.main.async("ChatRoomService::joinSuccess", new Runnable(){

                                        @Override
                                        public void run() {
                                            joiningCompletion.onSucceed();
                                        }
                                    });
                                }
                            }).onFailure(new OnFailure(){

                                public void onFailure(final Error error) {
                                    DispatchQueue.main.async("ChatRoomService::subscribe", new Runnable(){

                                        @Override
                                        public void run() {
                                            joiningCompletion.onFailure(error);
                                        }
                                    });
                                }
                            }));
                        }

                        @Override
                        public void onFailure(final @NonNull Error error) {
                            DispatchQueue.main.async("ChatRoomService::joinFailure", new Runnable(){

                                @Override
                                public void run() {
                                    joiningCompletion.onFailure(error);
                                }
                            });
                        }
                    }));
                }
            });
        }
    }

    @Override
    public void leave(final @NonNull ChatRoom chatRoom, @Nullable HMR.Completion completion) {
        Log.i((String)TAG, (Object)Trace.once((String)"leave chatRoom: %s", (Object[])new Object[]{chatRoom.getId()}));
        final RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::leave");
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login"));
            return;
        }
        HMRContext.work.async("ChatRoomService::leave", new Runnable(){

            @Override
            public void run() {
                ChatRoomServiceImpl.this.leaveChatRoom(chatRoom, true, richCompletion);
            }
        });
    }

    @Override
    public void kick(final @NonNull ChatRoom chatRoom, final @NonNull User user, final @Nullable Map<ChatRoomService.EKickInfo, String> map, @NonNull HMR.Completion completion) {
        final RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::kick");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"kick id:%s fellow:%s", (Object[])new Object[]{chatRoom.getId(), user.getId()}));
        HMRContext.work.async("ChatRoomService::kick", new Runnable(){

            @Override
            public void run() {
                long l = 300L;
                String string = "";
                if (map != null && map.containsKey((Object)ChatRoomService.EKickInfo.Time)) {
                    l = Long.parseLong((String)map.get((Object)ChatRoomService.EKickInfo.Time));
                }
                if (map != null && map.containsKey((Object)ChatRoomService.EKickInfo.Reason)) {
                    string = (String)map.get((Object)ChatRoomService.EKickInfo.Reason);
                }
                ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCKickOffUser(user.getId(), (int)chatRoom.getId(), l, string, richCompletion));
            }
        });
    }

    @Override
    public void addRole(@NonNull ChatRoom chatRoom, @NonNull User user, @NonNull String string, @NonNull HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::addRole");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"addRole id:%s fellow:%s role:%s", (Object[])new Object[]{chatRoom.getId(), user.getId(), string}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCChangeChatRoomRole(chatRoom.getId(), user.getId(), new ChatRoomProto.AdminRoleTypeEnum(string), ChatRoomProto.ChatRoomOpEnum.ADD, richCompletion));
    }

    @Override
    public void removeRole(@NonNull ChatRoom chatRoom, @NonNull User user, @NonNull String string, @NonNull HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::removeRole");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"removeRole id:%s fellow:%s role:%s", (Object[])new Object[]{chatRoom.getId(), user.getId(), string}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCChangeChatRoomRole(chatRoom.getId(), user.getId(), new ChatRoomProto.AdminRoleTypeEnum(string), ChatRoomProto.ChatRoomOpEnum.REMOVE, richCompletion));
    }

    @Override
    public void fetchMembers(final @NonNull ChatRoom chatRoom, final int n, final int n2, @NonNull HMR.CompletionArg<List<User>> completionArg) {
        final RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatRoomService::fetchMembers");
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"fetchMembers id:%s num:%s pos:%s", (Object[])new Object[]{chatRoom.getId(), n, n2}));
        HMRContext.work.async("ChatRoomService::fetchMembers", new Runnable(){

            @Override
            public void run() {
                ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCFetchMemberList((int)chatRoom.getId(), n, n2, (RichCompletionArg<List<User>>)richCompletionArg));
            }
        });
    }

    @Override
    public void fetchRoleMembers(@NonNull ChatRoom chatRoom, boolean bl, @NonNull HMR.CompletionArg<Map<String, List<User>>> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatRoomService::fetchRoleMembers");
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"fetch all roler Members id:%s, online:%s", (Object[])new Object[]{chatRoom.getId(), bl}));
        if (bl) {
            ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCFetchAdminList((int)chatRoom.getId(), "all", (RichCompletionArg<Map<String, List<User>>>)richCompletionArg));
        } else {
            ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCPullAllAdminUser((int)chatRoom.getId(), "all", (RichCompletionArg<Map<String, List<User>>>)richCompletionArg));
        }
    }

    @Override
    public void fetchBasicInfo(@NonNull ChatRoom chatRoom, @NonNull HMR.CompletionArg<ChatRoomInfo> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatService::fetchBasicInfo");
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"fetchBasicInfo id:%s", (Object[])new Object[]{chatRoom.getId()}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCFetchChatRoomInfo((int)chatRoom.getId(), (RichCompletionArg<ChatRoomInfo>)richCompletionArg));
    }

    @Override
    public void changeBasicInfo(@NonNull ChatRoom chatRoom, @NonNull Map<ChatRoomInfo.BasicInfoType, String> map, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::changeBasicInfo");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"changeBasicInfo id:%s", (Object[])new Object[]{chatRoom.getId()}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCChangeChatRoomInfo((int)chatRoom.getId(), map, richCompletion));
    }

    @Override
    public void muteMember(@NonNull ChatRoom chatRoom, @NonNull User user, @Nullable String string, @NonNull HMR.Completion completion) {
        this.doMuteOrUnmute(chatRoom, user, string, true, completion);
    }

    @Override
    public void unmuteMember(@NonNull ChatRoom chatRoom, @NonNull User user, @Nullable String string, @NonNull HMR.Completion completion) {
        this.doMuteOrUnmute(chatRoom, user, string, false, completion);
    }

    private void doMuteOrUnmute(ChatRoom chatRoom, User user, String string, boolean bl, HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::doMuteOrUnmute");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)((bl ? "mute" : "unmute") + " id:%s member:%s"), (Object[])new Object[]{chatRoom.getId(), user.getId()}));
        ((Channel)HMR.getService(Channel.class)).run((Channel.RPC)new RPCDisableUserText(HMR.getMe().getId(), user.getId(), (int)chatRoom.getId(), 259200L, bl, string == null ? "" : string, richCompletion));
    }

    @Override
    public void fetchMutedUsers(@NonNull ChatRoom chatRoom, @NonNull HMR.CompletionArg<Set<User>> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatRoomService::fetchMutedUsers");
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"fetchMutedMembers roomId:%s", (Object[])new Object[]{chatRoom.getId()}));
        ((Channel)HMR.getService(Channel.class)).run((Channel.RPC)new RPCFetchMutedMemberList((int)chatRoom.getId(), (RichCompletionArg<Set<User>>)richCompletionArg));
    }

    @Override
    public void isMuted(@NonNull ChatRoom chatRoom, final @NonNull User user, @NonNull HMR.CompletionArg<Boolean> completionArg) {
        final RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatRoomService::isMuted");
        this.fetchMutedUsers(chatRoom, new HMR.CompletionArg<Set<User>>(){

            public void onSuccess(Set<User> set) {
                if (set.size() > 0 && set.contains(user)) {
                    CompletionUtils.dispatchSuccess((RichCompletionArg)richCompletionArg, (Object)true);
                } else {
                    CompletionUtils.dispatchSuccess((RichCompletionArg)richCompletionArg, (Object)false);
                }
            }

            public void onFailed(Error error) {
                CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)error);
            }
        });
    }

    @Override
    public void fetchOnlineUserInfoList(@NonNull ChatRoom chatRoom, @NonNull HMR.CompletionArg<Map<User, Map<String, String>>> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "ChatRoomService::fetchOnlineUserInfoList");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().method("fetchOnlineUserInfoList").info("chatRoom", (Object)chatRoom.getId()));
        ((Channel)HMR.getService(Channel.class)).run((Channel.RPC)new RPCFetchOnlineUserInfoList(chatRoom.getId(), (RichCompletionArg<Map<User, Map<String, String>>>)richCompletionArg));
    }

    @Override
    public void fetchUserInfo(@NonNull ChatRoom chatRoom, @NonNull User user, @NonNull HMR.CompletionArg<Map<String, String>> completionArg) {
        RichCompletionArg richCompletionArg = new RichCompletionArg(completionArg, "");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletionArg)richCompletionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().method("fetchUserInfo").info("chatRoom", (Object)chatRoom.getId()).info("user", (Object)user.getId()));
        ((Channel)HMR.getService(Channel.class)).run((Channel.RPC)new RPCFetchUserInfo(chatRoom.getId(), user.getId(), (RichCompletionArg<Map<String, String>>)richCompletionArg));
    }

    @Override
    public void setUserInfo(@NonNull ChatRoom chatRoom, @NonNull Map<String, String> map, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "ChatRoomService::setUserInfo");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().method("setUserInfo").info("chatRoom", (Object)chatRoom.getId()).info("infoMap", map));
        ((Channel)HMR.getService(Channel.class)).run((Channel.RPC)new RPCSetUserInfo(chatRoom.getId(), map, richCompletion));
    }

    @Override
    public void deleteUserInfoByKeys(@NonNull ChatRoom chatRoom, @NonNull Set<String> set, @Nullable HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().method("deleteUserInfoByKeys").info("chatRoom", (Object)chatRoom.getId()).info("keys", set));
        ((Channel)HMR.getService(Channel.class)).run((Channel.RPC)new RPCDeleteUserInfo(chatRoom.getId(), HMR.getMe().getId(), set, richCompletion));
    }

    @Override
    public void addListener(@NonNull ChatRoomService.ChatRoomListener chatRoomListener) {
        this.listeners.add(chatRoomListener);
        Log.i((String)TAG, (Object)Trace.once().method("addListener").info("name", (Object)chatRoomListener.getClass().getSimpleName()).info("size", (Object)this.listeners.size()));
    }

    @Override
    public void removeListener(@NonNull ChatRoomService.ChatRoomListener chatRoomListener) {
        this.listeners.remove(chatRoomListener);
        Log.i((String)TAG, (Object)Trace.once().method("removeListener").info("name", (Object)chatRoomListener.getClass().getSimpleName()).info("size", (Object)this.listeners.size()));
    }

    @Override
    public void addMemberListener(@NonNull ChatRoomService.MemberListener memberListener) {
        this.memberListeners.add(memberListener);
        Log.i((String)TAG, (Object)Trace.once().method("addMemberListener").info("name", (Object)memberListener.getClass().getSimpleName()).info("size", (Object)this.memberListeners.size()));
    }

    @Override
    public void removeMemberListener(@NonNull ChatRoomService.MemberListener memberListener) {
        this.memberListeners.remove(memberListener);
        Log.i((String)TAG, (Object)Trace.once().method("removeMemberListener").info("name", (Object)memberListener.getClass().getSimpleName()).info("size", (Object)this.memberListeners.size()));
    }

    private Message handleTextMessage(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 773837) {
            return null;
        }
        ChatRoomProto.PCS_TextChatBc pCS_TextChatBc = new ChatRoomProto.PCS_TextChatBc();
        receiver.unmarshallWrap((Marshallable)pCS_TextChatBc);
        ChatRoom chatRoom = new ChatRoom(pCS_TextChatBc.roomId.longValue());
        Text text = new Text(pCS_TextChatBc.chat);
        Message message = new Message((Identifiable)chatRoom, (Content)text);
        message.setState((Message.State)new Archived());
        message.setSender((Identifiable)new User(pCS_TextChatBc.uid.longValue()));
        String string = pCS_TextChatBc.chatProps.get("uuid");
        if (TextUtils.isEmpty((CharSequence)string)) {
            message.setUuid(UUID.randomUUID().toString());
        } else {
            message.setUuid(pCS_TextChatBc.chatProps.get("uuid"));
        }
        message.setAppExtra(pCS_TextChatBc.chatProps.get("extra"));
        message.setTimestamp(System.currentTimeMillis());
        return message;
    }

    private Message handleUnicastMessage(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 526029) {
            Log.e((String)TAG, (Object)Trace.once().method("SendUnicastUc error").msg("uri error :%d", new Object[]{receiver.getUri().intValue()}));
            return null;
        }
        ChatRoomProto.PCS_SendUnicastUc pCS_SendUnicastUc = new ChatRoomProto.PCS_SendUnicastUc();
        receiver.unmarshallWrap((Marshallable)pCS_SendUnicastUc);
        ChatRoom chatRoom = new ChatRoom(pCS_SendUnicastUc.roomId.longValue());
        User user = new User(pCS_SendUnicastUc.receiver.longValue());
        if (this.chatRooms.size() <= 0) {
            Log.e((String)TAG, (Object)Trace.once().method("SendUniCastUc error").msg("chatRoom record error, roomId: %d, receiver: %d", new Object[]{chatRoom.getId(), user.getId()}));
            return null;
        }
        if (!this.chatRooms.contains((Object)chatRoom)) {
            Log.e((String)TAG, (Object)Trace.once().method("SendUniCastUc error").msg("chatRoom record error, chatRoom size; %d, roomId: %d, receiver: %d", new Object[]{this.chatRooms.size(), chatRoom.getId(), user.getId()}));
            return null;
        }
        Message message = new Message((Identifiable)chatRoom, (Content)ChatRoomService.Signal.unicast(user, pCS_SendUnicastUc.content));
        message.setSender((Identifiable)new User(pCS_SendUnicastUc.uid.longValue()));
        if (TextUtils.isEmpty((CharSequence)pCS_SendUnicastUc.requestId)) {
            message.setUuid(UUID.randomUUID().toString());
        } else {
            message.setUuid(pCS_SendUnicastUc.requestId);
        }
        message.setTimestamp(pCS_SendUnicastUc.timestamp.longValue());
        message.setAppExtra(pCS_SendUnicastUc.extraMap.get("hmr_extra_key"));
        Log.i((String)TAG, (Object)Trace.once((String)"Receive SendUniCastUc: %s", (Object[])new Object[]{pCS_SendUnicastUc.requestId}));
        return message;
    }

    private Message handleBroadcastMessage(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 271565) {
            return null;
        }
        ChatRoomProto.PCS_SendBroadcastBc pCS_SendBroadcastBc = new ChatRoomProto.PCS_SendBroadcastBc();
        receiver.unmarshallWrap((Marshallable)pCS_SendBroadcastBc);
        Message message = new Message((Identifiable)new ChatRoom(pCS_SendBroadcastBc.roomId.longValue()), (Content)ChatRoomService.Signal.broadcast(pCS_SendBroadcastBc.content));
        message.setSender((Identifiable)new User(pCS_SendBroadcastBc.uid.longValue()));
        if (TextUtils.isEmpty((CharSequence)pCS_SendBroadcastBc.requestId)) {
            message.setUuid(UUID.randomUUID().toString());
        } else {
            message.setUuid(pCS_SendBroadcastBc.requestId);
        }
        message.setTimestamp(System.currentTimeMillis());
        message.setAppExtra(pCS_SendBroadcastBc.extraMap.get("hmr_extra_key"));
        Log.i((String)TAG, (Object)Trace.once((String)"Receive SendBroadcastBc: %s", (Object[])new Object[]{message.getUuid()}));
        return message;
    }

    private void handleUserInfoChanged(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 272333) {
            return;
        }
        final ChatRoomProto.PCS_UserInfoChangeBc pCS_UserInfoChangeBc = new ChatRoomProto.PCS_UserInfoChangeBc();
        receiver.unmarshallWrap((Marshallable)pCS_UserInfoChangeBc);
        final ChatRoom chatRoom = new ChatRoom(pCS_UserInfoChangeBc.roomid.longValue());
        final User user = new User(pCS_UserInfoChangeBc.uid.longValue());
        DispatchQueue.main.async("ChatRoomService::handleChatMutation", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.MemberListener memberListener : ChatRoomServiceImpl.this.memberListeners) {
                    if (pCS_UserInfoChangeBc.op.intValue() == ChatRoomProto.PCS_UserInfoChangeBc.OpType.SET.getType()) {
                        memberListener.onUserInfoSet(chatRoom, user, pCS_UserInfoChangeBc.infos);
                        continue;
                    }
                    if (pCS_UserInfoChangeBc.op.intValue() == ChatRoomProto.PCS_UserInfoChangeBc.OpType.DEL.getType()) {
                        memberListener.onUserInfoDeleted(chatRoom, user, pCS_UserInfoChangeBc.infos);
                        continue;
                    }
                    Log.w((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("handleUserInfoChanged").info("chatroom", (Object)chatRoom.getId()).msg("opType[%d] is not parse", new Object[]{pCS_UserInfoChangeBc.op}));
                }
            }
        });
    }

    private void handleChatMutation(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 272077) {
            return;
        }
        final ChatRoomProto.PCS_DisableUserTextBc pCS_DisableUserTextBc = new ChatRoomProto.PCS_DisableUserTextBc();
        receiver.unmarshallWrap((Marshallable)pCS_DisableUserTextBc);
        final ChatRoom chatRoom = new ChatRoom(pCS_DisableUserTextBc.roomid.longValue());
        final User user = new User(pCS_DisableUserTextBc.opUid.longValue());
        final HashSet<User> hashSet = new HashSet<User>();
        for (Uint64 uint64 : pCS_DisableUserTextBc.tuids) {
            hashSet.add(new User(uint64.longValue()));
        }
        DispatchQueue.main.async("ChatRoomService::handleChatMutation", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.MemberListener memberListener : ChatRoomServiceImpl.this.memberListeners) {
                    if (pCS_DisableUserTextBc.disable) {
                        Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("onMemberMuted, size = " + hashSet.size())));
                        memberListener.onMemberMuted(chatRoom, user, hashSet, pCS_DisableUserTextBc.reason);
                        continue;
                    }
                    Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("onMemberUnmuted, size = " + hashSet.size())));
                    memberListener.onMemberUnmuted(chatRoom, user, hashSet, pCS_DisableUserTextBc.reason);
                }
            }
        });
    }

    private void handleMembersChanged(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 3423949) {
            return;
        }
        ChatRoomProto.PCS_ChatRoomUserBc pCS_ChatRoomUserBc = new ChatRoomProto.PCS_ChatRoomUserBc();
        receiver.unmarshallWrap((Marshallable)pCS_ChatRoomUserBc);
        final ChatRoom chatRoom = new ChatRoom(pCS_ChatRoomUserBc.roomId.longValue());
        final ArrayList<User> arrayList = new ArrayList<User>();
        final ArrayList<User> arrayList2 = new ArrayList<User>();
        if (pCS_ChatRoomUserBc.joinUsers.size() > 0) {
            for (Uint64 uint64 : pCS_ChatRoomUserBc.joinUsers) {
                arrayList.add(new User(uint64.longValue()));
            }
        }
        if (pCS_ChatRoomUserBc.leaveUsers.size() > 0) {
            for (Uint64 uint64 : pCS_ChatRoomUserBc.leaveUsers) {
                arrayList2.add(new User(uint64.longValue()));
            }
        }
        DispatchQueue.main.async("ChatRoomService::handleMembersChanged", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.MemberListener memberListener : ChatRoomServiceImpl.this.memberListeners) {
                    if (arrayList.size() > 0) {
                        Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("member join, size = " + arrayList.size())));
                        memberListener.onMemberJoined(chatRoom, arrayList);
                    }
                    if (arrayList2.size() <= 0) continue;
                    Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("member leave, size = " + arrayList2.size())));
                    memberListener.onMemberLeaved(chatRoom, arrayList2, 0, "\u79bb\u5f00");
                }
            }
        });
    }

    private void notifyUserLeaved(final @NonNull ChatRoom chatRoom, final @NonNull List<User> list, final int n, final @NonNull String string) {
        if (list.size() < 1) {
            return;
        }
        DispatchQueue.main.async("notifyUserLeave", new Runnable(){

            @Override
            public void run() {
                Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("memberLeave, users = " + list.toString())));
                for (ChatRoomService.MemberListener memberListener : ChatRoomServiceImpl.this.memberListeners) {
                    memberListener.onMemberLeaved(chatRoom, list, n, string);
                }
            }
        });
    }

    private void handleChatRoomDeleted(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 270285) {
            return;
        }
        final ChatRoomProto.PCS_DismissChatRoomBc pCS_DismissChatRoomBc = new ChatRoomProto.PCS_DismissChatRoomBc();
        receiver.unmarshallWrap((Marshallable)pCS_DismissChatRoomBc);
        DispatchQueue.main.async("ChatRoomService::handleChatRoomDeleted", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.ChatRoomListener chatRoomListener : ChatRoomServiceImpl.this.listeners) {
                    Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("onChatRoomDismissed, roomid = " + pCS_DismissChatRoomBc.roomid.longValue())));
                    chatRoomListener.onChatRoomDismissed(new ChatRoom(pCS_DismissChatRoomBc.roomid.longValue()), new User(pCS_DismissChatRoomBc.uid.longValue()));
                }
            }
        });
    }

    private void handleMemberKicked(byte[] byArray) {
        Uint64 uint642;
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 271053) {
            return;
        }
        ChatRoomProto.PCS_KickOffUserBc pCS_KickOffUserBc = new ChatRoomProto.PCS_KickOffUserBc();
        receiver.unmarshallWrap((Marshallable)pCS_KickOffUserBc);
        long l = ((Channel)ServiceProvider.get(Channel.class)).getInstanceId();
        final ArrayList<User> arrayList = new ArrayList<User>();
        for (Uint64 uint642 : pCS_KickOffUserBc.tuids) {
            Uint64 uint643 = pCS_KickOffUserBc.uid2InstanceIdMap.get(uint642);
            if (uint643 != null && uint643.longValue() != l) {
                Log.i((String)TAG, (Object)Trace.once().msg((Object)"notify instId is not equals local instId").info("currentUser", (Object)HMR.getMe().getId()).info("notifyUser", (Object)uint642.longValue()).info("notifyInstId", (Object)uint643.longValue()).info("localInstId", (Object)l));
                return;
            }
            arrayList.add(new User(uint642.longValue()));
        }
        if (arrayList.size() < 1) {
            return;
        }
        Object object = new ChatRoom(pCS_KickOffUserBc.topsid.longValue());
        uint642 = new User(pCS_KickOffUserBc.admin.longValue());
        if (arrayList.contains(HMR.getMe())) {
            this.handleLeaveChatRoom((ChatRoom)((Object)object));
        }
        DispatchQueue.main.async("ChatRoomService::handleMemberKicked", new Runnable((ChatRoom)((Object)object), (User)uint642, pCS_KickOffUserBc){
            final /* synthetic */ ChatRoom val$chatRoom;
            final /* synthetic */ User val$admin;
            final /* synthetic */ ChatRoomProto.PCS_KickOffUserBc val$bc;
            {
                this.val$chatRoom = chatRoom;
                this.val$admin = user;
                this.val$bc = pCS_KickOffUserBc;
            }

            @Override
            public void run() {
                for (ChatRoomService.MemberListener memberListener : ChatRoomServiceImpl.this.memberListeners) {
                    Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("onMemberKicked, size = " + arrayList.size())));
                    memberListener.onMemberKicked(this.val$chatRoom, this.val$admin, arrayList, this.val$bc.mReason);
                }
            }
        });
    }

    private void handleMemberRoleChanged(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 270797) {
            return;
        }
        final ChatRoomProto.PCS_UpdateChatRoomRolerBc pCS_UpdateChatRoomRolerBc = new ChatRoomProto.PCS_UpdateChatRoomRolerBc();
        receiver.unmarshallWrap((Marshallable)pCS_UpdateChatRoomRolerBc);
        if (ChatRoomProto.ChatRoomOpEnum.values()[pCS_UpdateChatRoomRolerBc.op.intValue()] != ChatRoomProto.ChatRoomOpEnum.ADD && ChatRoomProto.ChatRoomOpEnum.values()[pCS_UpdateChatRoomRolerBc.op.intValue()] != ChatRoomProto.ChatRoomOpEnum.REMOVE) {
            return;
        }
        final ChatRoom chatRoom = new ChatRoom(pCS_UpdateChatRoomRolerBc.roomid.longValue());
        final User user = new User(pCS_UpdateChatRoomRolerBc.uid.longValue());
        final User user2 = new User(pCS_UpdateChatRoomRolerBc.admin.longValue());
        final boolean bl = ChatRoomProto.ChatRoomOpEnum.values()[pCS_UpdateChatRoomRolerBc.op.intValue()] == ChatRoomProto.ChatRoomOpEnum.ADD;
        DispatchQueue.main.async("ChatRoomService::handleMemberRoleChanged", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.MemberListener memberListener : ChatRoomServiceImpl.this.memberListeners) {
                    if (bl) {
                        Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("onRoleAdded, uid = " + user.getId())));
                        memberListener.onRoleAdded(chatRoom, pCS_UpdateChatRoomRolerBc.roler, user2, user);
                        continue;
                    }
                    Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("onRoleRemoved, uid = " + user.getId())));
                    memberListener.onRoleRemoved(chatRoom, pCS_UpdateChatRoomRolerBc.roler, user2, user);
                }
            }
        });
    }

    private void handleBasicInfoChanged(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 270541) {
            return;
        }
        ChatRoomProto.PCS_UpdateChatRoomInfoBc pCS_UpdateChatRoomInfoBc = new ChatRoomProto.PCS_UpdateChatRoomInfoBc();
        receiver.unmarshallWrap((Marshallable)pCS_UpdateChatRoomInfoBc);
        final ChatRoom chatRoom = new ChatRoom(pCS_UpdateChatRoomInfoBc.roomid.intValue());
        final HashMap<ChatRoomInfo.BasicInfoType, String> hashMap = new HashMap<ChatRoomInfo.BasicInfoType, String>();
        for (Map.Entry<String, String> entry : pCS_UpdateChatRoomInfoBc.props.entrySet()) {
            String string = entry.getKey();
            if ("Extention".equals(string)) {
                string = ChatRoomInfo.BasicInfoType.AppExtra.name();
            }
            hashMap.put(ChatRoomInfo.BasicInfoType.valueOf(string), entry.getValue());
        }
        DispatchQueue.main.async("ChatRoomService::handleBasicInfoChanged", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.ChatRoomListener chatRoomListener : ChatRoomServiceImpl.this.listeners) {
                    Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("onBasicInfoChanged, roomid = " + chatRoom.getId())));
                    chatRoomListener.onBasicInfoChanged(chatRoom, hashMap);
                }
            }
        });
    }

    private void handleUserCountChanged(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 3421389) {
            return;
        }
        ChatRoomProto.PCS_PushChatRoomUserCountBC pCS_PushChatRoomUserCountBC = new ChatRoomProto.PCS_PushChatRoomUserCountBC();
        receiver.unmarshallWrap((Marshallable)pCS_PushChatRoomUserCountBC);
        final ChatRoom chatRoom = new ChatRoom(pCS_PushChatRoomUserCountBC.topsid.longValue());
        final int n = pCS_PushChatRoomUserCountBC.totalCount.intValue();
        DispatchQueue.main.async("ChatRoomService::handleUserCountChanged", new Runnable(){

            @Override
            public void run() {
                for (ChatRoomService.MemberListener memberListener : ChatRoomServiceImpl.this.memberListeners) {
                    Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("onMemberCountChanged, count = " + n)));
                    memberListener.onMemberCountChanged(chatRoom, n);
                }
            }
        });
    }

    private void addChatRoom(ChatRoom chatRoom) {
        this.chatRooms.add(chatRoom);
    }

    private void removeChatRoom(ChatRoom chatRoom) {
        this.chatRooms.remove((Object)chatRoom);
    }

    private void clearChatRoomData(ChatRoom chatRoom) {
        this._unsubscribeChatRoomBC(chatRoom);
        ((MQService)HMR.getService(MQService.class)).removeSource((MQService.Source)new Source((Source.Mode)new Source.Private(this.getPrivatedTopic(), MQService.FetchStrategy.IgnoreBefore, 20000L)));
        String string = this.getSharedTopic(String.valueOf(chatRoom.getId()));
        ((MQService)HMR.getService(MQService.class)).removeSource((MQService.Source)new Source((Source.Mode)new Source.Shared(chatRoom.getId(), string, ChatRoomServiceImpl.getRegion(), MQService.FetchStrategy.IgnoreBefore, 20000L)));
    }

    private void handleJoinChatRoom(ChatRoom chatRoom) {
        String string = this.getSharedTopic(String.valueOf(chatRoom.getId()));
        Source.Shared shared = new Source.Shared(chatRoom.getId(), string, ChatRoomServiceImpl.getRegion(), MQService.FetchStrategy.IgnoreBefore, 20000L);
        shared.setCheckIntegrity(true);
        ((MQService)HMR.getService(MQService.class)).addSource((MQService.Source)new Source((Source.Mode)shared));
        Source.Private private_ = new Source.Private(this.getPrivatedTopic(), MQService.FetchStrategy.IgnoreBefore, 20000L);
        private_.setCheckIntegrity(true);
        ((MQService)HMR.getService(MQService.class)).addSource((MQService.Source)new Source((Source.Mode)private_));
    }

    private void leaveChatRoom(final ChatRoom chatRoom, boolean bl, final RichCompletion richCompletion) {
        if (HMR.getMe() != null && HMR.getMe().isAnonymous()) {
            this._unsubscribeChatRoomBC(chatRoom);
            CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
        } else {
            if (bl) {
                this.handleLeaveChatRoom(chatRoom);
            }
            ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCLeaveChatRoom((int)chatRoom.getId(), new RichCompletion("ChatRoomService::leaveChatRoom").onSuccess(new OnSuccess(){

                public void onSuccess() {
                    Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("leave chatRoom Done").info("id: ", (Object)chatRoom.getId()));
                    ChatRoomServiceImpl.this.handleLeaveChatRoom(chatRoom);
                    CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
                }
            }).onFailure(new OnFailure(){

                public void onFailure(Error error) {
                    Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("leaveChannel fail").info("id: ", (Object)chatRoom.getId()));
                    CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)error);
                }
            })));
        }
    }

    private void handleLeaveChatRoom(ChatRoom chatRoom) {
        this.clearChatRoomData(chatRoom);
        this.removeChatRoom(chatRoom);
        this.removePingChatRoom(chatRoom);
        this.resetDuration();
    }

    private void _subscribeChatRoomBC(ChatRoom chatRoom, final @NonNull RichCompletion richCompletion) {
        final long l = chatRoom.getId();
        UserGroupType userGroupType = new UserGroupType(0x80000000L, l);
        UserGroupType userGroupType2 = new UserGroupType(0x80000001L, l);
        UserGroupType userGroupType3 = new UserGroupType(0x80000002L, l);
        ArrayList<UserGroupType> arrayList = new ArrayList<UserGroupType>();
        arrayList.add(userGroupType);
        arrayList.add(userGroupType2);
        arrayList.add(userGroupType3);
        YYServiceCore.getInstance().subscribeBroadcast(arrayList, (IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam>(){

            public void onSuccess(int n, BroadSubOrUnSubTask.ResponseParam responseParam) {
                Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("subscribeBroadcast success").msg("resCode:%d, roomId:%d", new Object[]{responseParam.mResCode, l}));
                CompletionUtils.dispatchSuccess((RichCompletion)richCompletion);
            }

            public void onFail(int n, int n2, int n3, Exception exception) {
                Log.e((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("subscribeBroadcast failed").msg("sdkResCode:%d, srvResCode:%d, roomId:%d", new Object[]{n2, n3, l}));
                CompletionUtils.dispatchFailure((RichCompletion)richCompletion, (Error)new Error(n3, "service err"));
            }
        });
    }

    private void _unsubscribeChatRoomBC(ChatRoom chatRoom) {
        final long l = chatRoom.getId();
        UserGroupType userGroupType = new UserGroupType(0x80000000L, l);
        UserGroupType userGroupType2 = new UserGroupType(0x80000001L, l);
        UserGroupType userGroupType3 = new UserGroupType(0x80000002L, l);
        ArrayList<UserGroupType> arrayList = new ArrayList<UserGroupType>();
        arrayList.add(userGroupType);
        arrayList.add(userGroupType2);
        arrayList.add(userGroupType3);
        YYServiceCore.getInstance().unSubscribeBroadcast(arrayList, (IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam>(){

            public void onSuccess(int n, BroadSubOrUnSubTask.ResponseParam responseParam) {
                Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("unSubscribeBroadcast success").msg("resCode:%d, roomId:%d", new Object[]{responseParam.mResCode, l}));
            }

            public void onFail(int n, int n2, int n3, Exception exception) {
                Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("unSubscribeBroadcast failed").msg("sdkResCode:%d, srvResCode:%d, roomId:%d", new Object[]{n2, n3, l}));
            }
        });
    }

    private void addPingChatRoom(ChatRoom chatRoom) {
        this.pingChatRooms.add(chatRoom);
        if (this.pingChatRooms.size() > 0) {
            this.setupKeepAliveTimer();
        }
    }

    private void removePingChatRoom(ChatRoom chatRoom) {
        this.pingChatRooms.remove((Object)chatRoom);
        if (this.pingChatRooms.size() <= 0) {
            this.cancelKeepAliveTimer();
        }
    }

    private void setupKeepAliveTimer() {
        if (this.keepAliveTimer != null) {
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().msg((Object)"setup KeepAlive Timer"));
        this.keepAliveTimerTask = new TimerTask(){

            @Override
            public void run() {
                ChatRoomServiceImpl.this.chatRoomsKeepAlive();
            }
        };
        this.keepAliveTimer = new Timer();
        this.keepAliveTimer.schedule(this.keepAliveTimerTask, 1000L, (long)(keepAliveInterval * 1000));
    }

    private void cancelKeepAliveTimer() {
        if (this.keepAliveTimer == null) {
            return;
        }
        Log.i((String)TAG, (Object)Trace.once().msg((Object)"cancel KeepAlive Timer"));
        this.keepAliveTimer.cancel();
        this.keepAliveTimer.purge();
        this.keepAliveTimer = null;
    }

    private void chatRoomsKeepAlive() {
        Log.i((String)TAG, (Object)Trace.once().method("chatRoomsKeepAlive").msg((Object)("ping, size: " + this.pingChatRooms.size())));
        for (ChatRoom chatRoom : this.pingChatRooms) {
            final int n = (int)chatRoom.getId();
            ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCPingChatRoom(n, null, new RichCompletion(new HMR.Completion(){

                public void onSuccess() {
                    Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("chatRoomsKeepAlive").msg((Object)("pong: " + n)));
                }

                public void onFailed(Error error) {
                    Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("chatRoomsKeepAlive").msg((Object)("pong fail: " + n + ", error: " + error.toString())));
                }
            }, "RPCPingChatRoom")));
        }
    }

    private void updateDuration(int n) {
        if (n == 0) {
            this.resetDuration();
            return;
        }
        kRejoinConditionGap = n * 1000;
        keepAliveInterval = n / 3;
    }

    private void resetDuration() {
        kRejoinConditionGap = 60000L;
        keepAliveInterval = 10;
    }

    public void onPreChannelConnected() {
        if (this.mInitialTimeInterval < 946656000L) {
            this.mInitialTimeInterval = YYServiceCore.getInstance().getLastSyncServerTS();
        }
        Log.i((String)TAG, (Object)Trace.once().method("onPreChannelConnected: " + this.mInitialTimeInterval));
    }

    public void onChannelConnected() {
        HMRContext.work.async("ChatRoomService::onChannelConnected", new Runnable(){

            @Override
            public void run() {
                Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onChannelConnected"));
                ChatRoomServiceImpl.this.leaveChatRoomIfNeed();
                ChatRoomServiceImpl.this.resetInitialTimeInterval();
            }
        });
    }

    public void onChannelDisconnected() {
        HMRContext.work.async("ChatRoomService::onChannelDisconnected", new Runnable(){

            @Override
            public void run() {
                Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("onChannelDisconnected"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveChatRoomIfNeed() {
        boolean bl;
        long l = ((Channel)HMR.getService(Channel.class)).getAlignmentServerTS();
        if (l < 1L) {
            Log.w((String)TAG, (Object)("get alignment server ts: " + l));
            l = System.currentTimeMillis();
        }
        long l2 = l - this.mInitialTimeInterval;
        Log.i((String)TAG, (Object)Trace.once().method("isChatRoomTimeOut").msg((Object)("diff:" + l2)));
        boolean bl2 = bl = this.mInitialTimeInterval > 946656000L && l2 >= kRejoinConditionGap;
        if (!bl) {
            Log.i((String)TAG, (Object)"leaveChatRoomIfNeed return");
            return;
        }
        if (this.chatRooms.size() > 0) {
            Log.i((String)TAG, (Object)"Leave all chatroom for offline");
        }
        Set<ChatRoom> set = this.chatRooms;
        synchronized (set) {
            ArrayList<User> arrayList = new ArrayList<User>();
            arrayList.add(HMR.getMe());
            for (ChatRoom chatRoom : this.chatRooms) {
                this.notifyUserLeaved(chatRoom, arrayList, 1, "\u65ad\u5f00\u8fde\u63a5");
                this.leave(chatRoom, null);
            }
        }
    }

    private boolean isChatRoomTimeOut() {
        long l = System.currentTimeMillis();
        long l2 = l - this.mInitialTimeInterval;
        Log.i((String)TAG, (Object)Trace.once().method("isChatRoomTimeOut").msg((Object)("diff:" + l2)));
        long l3 = 60000L;
        return this.mInitialTimeInterval > 946656000L && l2 >= 60000L;
    }

    public static String getServiceName(String string) {
        return String.format(Locale.US, "%s_%s", ChatRoomServiceImpl.getRegion(), string);
    }

    private void resetInitialTimeInterval() {
        this.mInitialTimeInterval = 0L;
    }

    static {
        keepAliveInterval = 10;
    }
}

