/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.ChatRoomRPC;
import com.hummer.im.shared.completion.Completion;
import com.hummer.im.shared.completion.CompletionUtils;

public class RPCSendBroadcast
extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public static final String TAG = "RPCSendBroadcast";
    private final long roomId;
    private final String content;
    private final Completion completion;

    public RPCSendBroadcast(long l, String string, Completion completion) {
        this.roomId = l;
        this.content = string;
        this.completion = completion;
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_SendBroadcastReq pCS_SendBroadcastReq = new ChatRoomProto.PCS_SendBroadcastReq();
        pCS_SendBroadcastReq.appKey = Uint32.toUInt(HMRContext.getAppId());
        pCS_SendBroadcastReq.roomId = Uint32.toUInt(this.roomId);
        pCS_SendBroadcastReq.uid = Uint64.toUInt(HMR.getMe().getId());
        pCS_SendBroadcastReq.content = this.content;
        return pCS_SendBroadcastReq;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res pCS_CommonOperatorAuth2Res) {
        CompletionUtils.dispatchSuccess((Completion)this.completion);
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure((Completion)this.completion, (Error)error);
    }

    public String getFunctionName() {
        return "SendBroadcast";
    }

    public String serviceName() {
        return "chatroom_auther";
    }
}

