/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.ChatRoomRPC;
import com.hummer.im.id.User;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RPCPullAllAdminUser
extends ChatRoomRPC<ChatRoomProto.PCS_ChatRoomManagerRes> {
    private final CompletionArg<Map<String, List<User>>> mCompletion;
    private final int roomid;
    private final String role;

    public RPCPullAllAdminUser(int n, String string, CompletionArg<Map<String, List<User>>> completionArg) {
        this.roomid = n;
        this.role = string;
        this.mCompletion = completionArg;
    }

    public String getFunctionName() {
        return "GetChatRoomManager";
    }

    public String serviceName() {
        return "chatroom_smember";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_ChatRoomManagerReq pCS_ChatRoomManagerReq = new ChatRoomProto.PCS_ChatRoomManagerReq();
        pCS_ChatRoomManagerReq.roomId = Uint32.toUInt(this.roomid);
        pCS_ChatRoomManagerReq.appkey = Uint32.toUInt(HMRContext.appId);
        pCS_ChatRoomManagerReq.role = this.role;
        return pCS_ChatRoomManagerReq;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_ChatRoomManagerRes pCS_ChatRoomManagerRes) {
        HashMap hashMap = new HashMap();
        if (pCS_ChatRoomManagerRes.admins.size() > 0) {
            for (Map.Entry<String, ArrayList<Uint64>> entry : pCS_ChatRoomManagerRes.admins.entrySet()) {
                String string = entry.getKey();
                ArrayList<User> arrayList = new ArrayList<User>();
                List list = pCS_ChatRoomManagerRes.admins.get(string);
                for (Uint64 uint64 : list) {
                    User user = new User(uint64.longValue());
                    arrayList.add(user);
                }
                hashMap.put(string, arrayList);
            }
        }
        CompletionUtils.dispatchSuccess(this.mCompletion, hashMap);
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure(this.mCompletion, (Error)error);
    }
}

