/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.ChatRoomRPC;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;

public class RPCLeaveChatRoom
extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    private final CompletionArg<ChatRoom> mCompletion;
    private final int roomId;

    public RPCLeaveChatRoom(int n, CompletionArg<ChatRoom> completionArg) {
        this.roomId = n;
        this.mCompletion = completionArg;
    }

    public String getFunctionName() {
        return "LeaveChatRoom";
    }

    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_LeaveChatRoomReq pCS_LeaveChatRoomReq = new ChatRoomProto.PCS_LeaveChatRoomReq();
        pCS_LeaveChatRoomReq.appkey = Uint32.toUInt(HMRContext.appId);
        pCS_LeaveChatRoomReq.roomid = Uint32.toUInt(this.roomId);
        pCS_LeaveChatRoomReq.uid = Uint64.toUInt(HMR.getMe().getId());
        return pCS_LeaveChatRoomReq;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res pCS_CommonOperatorAuth2Res) {
        CompletionUtils.dispatchSuccess(this.mCompletion, (Object)new ChatRoom(pCS_CommonOperatorAuth2Res.roomId.longValue()));
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure(this.mCompletion, (Error)error);
    }
}

