/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.ChatRoomRPC;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;

public class RPCKickOffUser
extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    private final CompletionArg<ChatRoom> completion;
    private final long uid;
    private final int roomId;
    private final long secs;
    private final String reason;

    public RPCKickOffUser(long l, int n, long l2, String string, CompletionArg<ChatRoom> completionArg) {
        this.uid = l;
        this.roomId = n;
        this.secs = l2;
        this.reason = string;
        this.completion = completionArg;
    }

    public String getFunctionName() {
        return "KickOffUser";
    }

    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_KickOffReq pCS_KickOffReq = new ChatRoomProto.PCS_KickOffReq();
        pCS_KickOffReq.appkey = Uint32.toUInt(HMRContext.appId);
        pCS_KickOffReq.roomid = Uint32.toUInt(this.roomId);
        pCS_KickOffReq.admin = Uint64.toUInt(HMR.getMe().getId());
        pCS_KickOffReq.uid = Uint64.toUInt(this.uid);
        pCS_KickOffReq.secs = Uint64.toUInt(this.secs);
        pCS_KickOffReq.reason = this.reason;
        return pCS_KickOffReq;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res pCS_CommonOperatorAuth2Res) {
        CompletionUtils.dispatchSuccess(this.completion, (Object)new ChatRoom(pCS_CommonOperatorAuth2Res.roomId.longValue()));
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, (Error)error);
    }
}

