/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom.Challenges;
import com.hummer.im.chatroom._internals.ChallengeImpl;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.ChatRoomRPC;
import com.hummer.im.shared.completion.Completion;
import com.hummer.im.shared.completion.CompletionUtils;
import java.util.Map;

public final class RPCJoinChatRoom
extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    private Challenges.JoiningCompletion authCompletion = null;
    private Map<String, String> joinProps;
    private boolean bTwice;
    private String password;
    private Completion completion;
    private int roomId;

    public RPCJoinChatRoom(int n, Map<String, String> map, Challenges.JoiningCompletion joiningCompletion) {
        this.roomId = n;
        this.joinProps = map;
        this.authCompletion = joiningCompletion;
        this.bTwice = false;
        this.password = "";
        this.completion = null;
    }

    public RPCJoinChatRoom(int n, String string, Map<String, String> map, Completion completion) {
        this.roomId = n;
        this.joinProps = map;
        this.password = string;
        this.completion = completion;
        this.bTwice = true;
    }

    public String getFunctionName() {
        return "JoinChatRoom";
    }

    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_JoinChatRoomReq pCS_JoinChatRoomReq = new ChatRoomProto.PCS_JoinChatRoomReq();
        pCS_JoinChatRoomReq.appkey = Uint32.toUInt(HMRContext.appId);
        pCS_JoinChatRoomReq.roomid = Uint32.toUInt(this.roomId);
        pCS_JoinChatRoomReq.uid = Uint64.toUInt(HMR.getMe().getId());
        pCS_JoinChatRoomReq.joinProps = this.joinProps;
        return pCS_JoinChatRoomReq;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res pCS_CommonOperatorAuth2Res) {
        HMRContext.work.async(() -> {
            if (this.authCompletion != null) {
                this.authCompletion.onSucceed();
            }
        });
    }

    @Override
    public void handleError(@Nullable ChatRoomProto.PCS_CommonOperatorAuth2Res pCS_CommonOperatorAuth2Res, @NonNull Error error) {
        assert (pCS_CommonOperatorAuth2Res != null);
        if (pCS_CommonOperatorAuth2Res.res.intValue() == 0) {
            return;
        }
        if (pCS_CommonOperatorAuth2Res.res.intValue() == 3006) {
            if (!this.bTwice) {
                ChallengeImpl.PasswordImpl passwordImpl = new ChallengeImpl.PasswordImpl(pCS_CommonOperatorAuth2Res.roomId.longValue());
                HMRContext.work.async(() -> {
                    if (this.authCompletion != null) {
                        this.authCompletion.onReceiveChallenge(passwordImpl);
                    }
                });
            } else {
                CompletionUtils.dispatchFailure((Completion)this.completion, (Error)new Error(pCS_CommonOperatorAuth2Res.res.intValue(), "service err"));
            }
        } else if (!this.bTwice) {
            HMRContext.work.async(() -> {
                if (this.authCompletion != null) {
                    this.authCompletion.onFailed(new Error(pCS_CommonOperatorAuth2Res.res.intValue(), "service err"));
                }
            });
        } else {
            CompletionUtils.dispatchFailure((Completion)this.completion, (Error)new Error(pCS_CommonOperatorAuth2Res.res.intValue(), "service err"));
        }
    }

    public void handleError(@NonNull Error error) {
        if (!this.bTwice) {
            HMRContext.work.async(() -> {
                if (this.authCompletion != null) {
                    this.authCompletion.onFailed(error);
                }
            });
        } else {
            CompletionUtils.dispatchFailure((Completion)this.completion, (Error)error);
        }
    }
}

