/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.ChatRoomRPC;
import com.hummer.im.id.User;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;
import java.util.LinkedList;
import java.util.List;

public class RPCFetchMemberList
extends ChatRoomRPC<ChatRoomProto.PCS_PullOnlineUserListRes> {
    private final CompletionArg<List<User>> completion;
    private final int roomId;
    private final int num;
    private final int pos;

    public RPCFetchMemberList(int n, int n2, int n3, CompletionArg<List<User>> completionArg) {
        this.roomId = n;
        this.num = n2;
        this.pos = n3;
        this.completion = completionArg;
    }

    public String getFunctionName() {
        return "GetUserList";
    }

    public String serviceName() {
        return "chatroom_online_query_d";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_PullOnlineUserListReq pCS_PullOnlineUserListReq = new ChatRoomProto.PCS_PullOnlineUserListReq();
        pCS_PullOnlineUserListReq.roomid = Uint32.toUInt(this.roomId);
        pCS_PullOnlineUserListReq.appkey = Uint32.toUInt(HMRContext.appId);
        pCS_PullOnlineUserListReq.num = Uint32.toUInt(this.num);
        pCS_PullOnlineUserListReq.pos = Uint32.toUInt(this.pos);
        return pCS_PullOnlineUserListReq;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_PullOnlineUserListRes pCS_PullOnlineUserListRes) {
        LinkedList<User> linkedList = new LinkedList<User>();
        for (Uint64 uint64 : pCS_PullOnlineUserListRes.users) {
            linkedList.add(new User(uint64.longValue()));
        }
        CompletionUtils.dispatchSuccess(this.completion, linkedList);
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, (Error)error);
    }
}

