/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.ChatRoomRPC;
import com.hummer.im.id.User;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RPCFetchAdminList
extends ChatRoomRPC<ChatRoomProto.PCS_PullAdminUserRes> {
    private final int roomId;
    private final String role;
    private final CompletionArg<Map<String, List<User>>> completion;

    public RPCFetchAdminList(int n, String string, CompletionArg<Map<String, List<User>>> completionArg) {
        this.roomId = n;
        this.role = string;
        this.completion = completionArg;
    }

    public String serviceName() {
        return "chatroom_online_query_d";
    }

    public String getFunctionName() {
        return "GetRolerList";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_PullAdminUserReq pCS_PullAdminUserReq = new ChatRoomProto.PCS_PullAdminUserReq();
        pCS_PullAdminUserReq.roomId = Uint32.toUInt(this.roomId);
        pCS_PullAdminUserReq.appkey = Uint32.toUInt(HMRContext.appId);
        pCS_PullAdminUserReq.role = this.role;
        return pCS_PullAdminUserReq;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_PullAdminUserRes pCS_PullAdminUserRes) {
        HashMap hashMap = new HashMap();
        for (Map.Entry<String, ArrayList<Uint64>> entry : pCS_PullAdminUserRes.admins.entrySet()) {
            String string = entry.getKey();
            ArrayList<User> arrayList = new ArrayList<User>();
            List list = pCS_PullAdminUserRes.admins.get(string);
            for (Uint64 uint64 : list) {
                User user = new User(uint64.longValue());
                arrayList.add(user);
            }
            hashMap.put(string, arrayList);
        }
        CompletionUtils.dispatchSuccess(this.completion, hashMap);
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, (Error)error);
    }
}

