/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.ChatRoomRPC;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;

public class RPCCreateChatRoom
extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public static final String TAG = "RPCCreateChatRoom";
    private final ChatRoomInfo chatRoomInfo;
    private final CompletionArg<ChatRoom> completion;

    public RPCCreateChatRoom(ChatRoomInfo chatRoomInfo, CompletionArg<ChatRoom> completionArg) {
        this.chatRoomInfo = chatRoomInfo;
        this.completion = completionArg;
    }

    public String getFunctionName() {
        return "CreateChatRoom";
    }

    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_CreateChatRoomReq pCS_CreateChatRoomReq = new ChatRoomProto.PCS_CreateChatRoomReq();
        pCS_CreateChatRoomReq.appKey = Uint32.toUInt(HMRContext.appId);
        pCS_CreateChatRoomReq.uid = Uint64.toUInt(HMR.getMe().getId());
        if (this.chatRoomInfo.getName() != null) {
            pCS_CreateChatRoomReq.props.put("Name", this.chatRoomInfo.getName());
        }
        if (this.chatRoomInfo.getDescription() != null) {
            pCS_CreateChatRoomReq.props.put("Description", this.chatRoomInfo.getDescription());
        }
        if (this.chatRoomInfo.getBulletin() != null) {
            pCS_CreateChatRoomReq.props.put("Bulletin", this.chatRoomInfo.getBulletin());
        }
        if (this.chatRoomInfo.getAppExtra() != null) {
            pCS_CreateChatRoomReq.props.put("Extention", this.chatRoomInfo.getAppExtra());
        }
        return pCS_CreateChatRoomReq;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res pCS_CommonOperatorAuth2Res) {
        CompletionUtils.dispatchSuccess(this.completion, (Object)new ChatRoom(pCS_CommonOperatorAuth2Res.roomId.longValue()));
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, (Error)error);
    }
}

