/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.ChatRoomRPC;
import com.hummer.im.shared.completion.Completion;
import com.hummer.im.shared.completion.CompletionUtils;
import java.util.Map;

public class RPCChatRoomTextChat
extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    public static final String TAG = "RPCChatRoomTextChat";
    private final Uint32 roomId;
    private final String chat;
    private final Map<String, String> chatProps;
    private final Map<String, String> extProps;
    private final Completion mCompletion;

    public RPCChatRoomTextChat(long l, String string, Map<String, String> map, Map<String, String> map2, Completion completion) {
        this.roomId = Uint32.toUInt(l);
        this.chat = string;
        this.chatProps = map;
        this.extProps = map2;
        this.mCompletion = completion;
    }

    public String getFunctionName() {
        return "SendTextChat";
    }

    public String serviceName() {
        return "chatroom_textchat";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_TextChat2Req pCS_TextChat2Req = new ChatRoomProto.PCS_TextChat2Req();
        pCS_TextChat2Req.uid = Uint64.toUInt(HMR.getMe().getId());
        pCS_TextChat2Req.chat = this.chat;
        pCS_TextChat2Req.roomId = this.roomId;
        pCS_TextChat2Req.appKey = Uint32.toUInt(HMRContext.appId);
        pCS_TextChat2Req.chatprops = this.chatProps;
        return pCS_TextChat2Req;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res pCS_CommonOperatorAuth2Res) {
        CompletionUtils.dispatchSuccess((Completion)this.mCompletion);
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure((Completion)this.mCompletion, (Error)error);
    }
}

