/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.ChatRoomRPC;
import com.hummer.im.shared.completion.Completion;
import com.hummer.im.shared.completion.CompletionUtils;
import java.util.Map;

public class RPCChangeChatRoomInfo
extends ChatRoomRPC<ChatRoomProto.PCS_CommonOperatorAuth2Res> {
    private final Completion mCompletion;
    private final int roomId;
    private final Map<ChatRoomInfo.BasicInfoType, String> props;

    public RPCChangeChatRoomInfo(int n, Map<ChatRoomInfo.BasicInfoType, String> map, Completion completion) {
        this.roomId = n;
        this.props = map;
        this.mCompletion = completion;
    }

    public String getFunctionName() {
        return "UpdateChatRoomInfo";
    }

    public String serviceName() {
        return "chatroom_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChatRoomProto.PCS_UpdateChatRoomInfoReq pCS_UpdateChatRoomInfoReq = new ChatRoomProto.PCS_UpdateChatRoomInfoReq();
        pCS_UpdateChatRoomInfoReq.appkey = Uint32.toUInt(HMRContext.appId);
        pCS_UpdateChatRoomInfoReq.roomid = Uint32.toUInt(this.roomId);
        pCS_UpdateChatRoomInfoReq.uid = Uint64.toUInt(HMR.getMe().getId());
        for (Map.Entry<ChatRoomInfo.BasicInfoType, String> entry : this.props.entrySet()) {
            String string = entry.getKey().name();
            pCS_UpdateChatRoomInfoReq.props.put(string, entry.getValue());
        }
        return pCS_UpdateChatRoomInfoReq;
    }

    @Override
    public void handleSuccess(@NonNull ChatRoomProto.PCS_CommonOperatorAuth2Res pCS_CommonOperatorAuth2Res) {
        CompletionUtils.dispatchSuccess((Completion)this.mCompletion);
    }

    public void handleError(@NonNull Error error) {
        CompletionUtils.dispatchFailure((Completion)this.mCompletion, (Error)error);
    }
}

