/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.rpc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.channel.Channel;
import com.hummer.im.chatroom._internals.packet.Marshallable;
import com.hummer.im.chatroom._internals.packet.Receiver;
import com.hummer.im.chatroom._internals.packet.Sender;
import com.hummer.im.chatroom._internals.packet.Uint32;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import junit.framework.Assert;

public abstract class ChatRoomRPC<Response extends Marshallable>
implements Channel.RPC {
    private static final String TAG = "ChatRoomRPC";

    public abstract Marshallable requestObj();

    public abstract void handleSuccess(@NonNull Response var1);

    public String protoType() {
        return null;
    }

    public byte[] getRequestBytes() {
        Sender sender = new Sender(this.requestObj());
        sender.endPack();
        return sender.getBytes();
    }

    public void handleResponse(@NonNull byte[] byArray) {
        Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Marshallable marshallable = (Marshallable)clazz.newInstance();
        Receiver receiver = new Receiver(byArray);
        receiver.unmarshallWrap2(marshallable);
        Field field = null;
        try {
            field = marshallable.getClass().getDeclaredField("res");
        }
        catch (Exception exception) {
            field = marshallable.getClass().getDeclaredField("rescode");
        }
        Assert.assertNotNull((Object)field);
        int n = ((Uint32)field.get(marshallable)).intValue();
        Assert.assertNotNull((Object)n);
        Log.i((String)TAG, (Object)Trace.once().method("ChatRoomRPC.handleResponse").info("code", (Object)n));
        if (n == 0) {
            this.handleSuccess(marshallable);
        } else {
            this.handleError(marshallable, new Error(n, "service error"));
        }
    }

    public void handleError(@Nullable Response Response, @NonNull Error error) {
        this.handleError(error);
    }
}

