/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.packet;

import android.annotation.SuppressLint;
import com.hummer.im.chatroom._internals.packet.Int64;
import com.hummer.im.chatroom._internals.packet.Uint16;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.packet.Uint8;
import com.hummer.im.chatroom._internals.packet.UnpackException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Unpack {
    protected ByteBuffer buffer;

    public Unpack(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public Unpack(byte[] byArray, int n, int n2) {
        this.buffer = ByteBuffer.wrap(byArray, n, n2);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public int size() {
        return this.buffer.remaining();
    }

    public Uint32 popUint32() {
        return new Uint32(this.buffer.getInt());
    }

    public int popInt() {
        return this.buffer.getInt();
    }

    public long popLong() {
        return this.buffer.getLong();
    }

    public Uint8 popUint8() {
        return new Uint8(this.buffer.get());
    }

    public Uint16 popUint16() {
        return new Uint16(this.buffer.getShort());
    }

    public Int64 popInt64() {
        return new Int64(this.buffer.getLong());
    }

    public Uint64 popUint64() {
        return new Uint64(this.buffer.getLong());
    }

    public boolean popBoolean() {
        return this.buffer.get() == 1;
    }

    public byte[] popBytes() {
        short s = this.buffer.getShort();
        byte[] byArray = new byte[this.toUnsigned(s)];
        this.buffer.get(byArray);
        return byArray;
    }

    public int toUnsigned(short s) {
        return s & 0xFFFF;
    }

    public String popString() {
        try {
            byte[] byArray = this.popBytes();
            return new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnpackException();
        }
    }

    public String popString(String string) {
        try {
            byte[] byArray = this.popBytes();
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnpackException();
        }
    }

    public String popString32() {
        try {
            int n = this.buffer.getInt();
            byte[] byArray = new byte[n];
            this.buffer.get(byArray);
            return new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnpackException();
        }
    }

    public byte[] popBytes32() {
        Uint32 uint32 = new Uint32(this.buffer.getInt());
        byte[] byArray = new byte[(int)uint32.longValue()];
        this.buffer.get(byArray);
        return byArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Pack [buffer=");
        stringBuilder.append(this.bufferString());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @SuppressLint(value={"DefaultLocale"})
    private String bufferString() {
        byte[] byArray = new byte[this.buffer.remaining()];
        int n = this.buffer.position();
        this.buffer.get(byArray);
        this.buffer.position(n);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF).toUpperCase()).append(" ");
        }
        return stringBuffer.toString();
    }

    public Map<String, String> popMapByKeyStringAndValueString() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = this.buffer.getInt();
        for (int i = 0; i < n; ++i) {
            String string = this.popString();
            String string2 = this.popString();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public Map<String, Set<Uint64>> popMapByKeyStringAndValueUint64Set() {
        HashMap<String, Set<Uint64>> hashMap = new HashMap<String, Set<Uint64>>();
        int n = this.buffer.getInt();
        for (int i = 0; i < n; ++i) {
            String string = this.popString();
            int n2 = this.buffer.getInt();
            HashSet<Uint64> hashSet = new HashSet<Uint64>();
            for (int j = 0; j < n2; ++j) {
                hashSet.add(this.popUint64());
            }
            hashMap.put(string, hashSet);
        }
        return hashMap;
    }

    public Set<Uint64> popUint64Set() {
        HashSet<Uint64> hashSet = new HashSet<Uint64>();
        int n = this.buffer.getInt();
        for (int i = 0; i < n; ++i) {
            hashSet.add(this.popUint64());
        }
        return hashSet;
    }
}

