/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.packet;

import android.annotation.SuppressLint;
import com.hummer.im.chatroom._internals.packet.Int64;
import com.hummer.im.chatroom._internals.packet.PackException;
import com.hummer.im.chatroom._internals.packet.Uint16;
import com.hummer.im.chatroom._internals.packet.Uint32;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.packet.Uint8;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Pack {
    protected ByteBuffer buffer = ByteBuffer.allocateDirect(512);

    public Pack() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    protected void autoExpand(int n) {
        this.expand(n, true);
    }

    protected void expand(int n, boolean bl) {
        this.expand(this.buffer.position(), n, bl);
    }

    private void expand(int n, int n2, boolean bl) {
        int n3 = n + n2;
        int n4 = bl ? Pack.normalizeCapacity(n3) : n3;
        if (n4 > this.buffer.capacity()) {
            this.capacity(n4);
        }
        if (n3 > this.buffer.limit()) {
            this.buffer.limit(n3);
        }
    }

    public void capacity(int n) {
        if (n > this.buffer.capacity()) {
            int n2 = this.buffer.position();
            int n3 = this.buffer.limit();
            ByteOrder byteOrder = this.buffer.order();
            ByteBuffer byteBuffer = this.buffer;
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
            byteBuffer.clear();
            byteBuffer2.put(byteBuffer);
            this.buffer = byteBuffer2;
            this.buffer.limit(n3);
            this.buffer.position(n2);
            this.buffer.order(byteOrder);
        }
    }

    protected static int normalizeCapacity(int n) {
        int n2;
        if (n < 0) {
            return Integer.MAX_VALUE;
        }
        return (n2 <<= (n2 = Integer.highestOneBit(n)) < n ? 1 : 0) < 0 ? Integer.MAX_VALUE : n2;
    }

    public void replaceUint32(int n, Uint32 uint32) {
        int n2 = this.buffer.position();
        this.buffer.position(n);
        this.buffer.putInt(uint32.intValue()).position(n2);
    }

    public void replaceUint16(int n, Uint16 uint16) {
        int n2 = this.buffer.position();
        this.buffer.position(n);
        this.buffer.putShort(uint16.shortValue()).position(n2);
    }

    public int size() {
        return this.buffer.position();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[this.buffer.limit()];
        this.buffer.get(byArray, 0, byArray.length);
        return byArray;
    }

    public Pack push(Uint32 uint32) {
        if (uint32 == null) {
            throw new PackException("Uint32 is null");
        }
        this.autoExpand(4);
        this.buffer.putInt(uint32.intValue());
        return this;
    }

    public Pack push(Integer n) {
        if (n == null) {
            throw new PackException("Integer is null");
        }
        this.autoExpand(4);
        this.buffer.putInt(n);
        return this;
    }

    public Pack push(Uint16 uint16) {
        if (uint16 == null) {
            throw new PackException("Uint16 is null");
        }
        this.autoExpand(2);
        this.buffer.putShort(uint16.shortValue());
        return this;
    }

    public Pack push(Long l) {
        if (l == null) {
            throw new PackException("Long is null");
        }
        this.autoExpand(8);
        this.buffer.putLong(l);
        return this;
    }

    public Pack push(Int64 int64) {
        if (int64 == null) {
            throw new PackException("Int64 is null");
        }
        this.autoExpand(8);
        this.buffer.putLong(int64.longValue());
        return this;
    }

    public Pack push(Uint64 uint64) {
        if (uint64 == null) {
            throw new PackException("Uint64 is null");
        }
        this.autoExpand(8);
        this.buffer.putLong(uint64.longValue());
        return this;
    }

    public Pack push(Uint8 uint8) {
        this.autoExpand(1);
        this.buffer.put(uint8.byteValue());
        return this;
    }

    public Pack push(byte by) {
        this.autoExpand(1);
        this.buffer.put(by);
        return this;
    }

    public Pack push(boolean bl) {
        this.autoExpand(1);
        this.buffer.put((byte)(bl ? 1 : 0));
        return this;
    }

    public Pack push(byte[] byArray) {
        this.autoExpand(2 + byArray.length);
        this.push(new Uint16(byArray.length));
        this.buffer.put(byArray);
        return this;
    }

    public Pack pushString32(byte[] byArray) {
        this.autoExpand(4 + byArray.length);
        this.push(new Uint32(byArray.length));
        this.buffer.put(byArray);
        return this;
    }

    public Pack push(String string) {
        try {
            byte[] byArray;
            if (string == null) {
                string = "";
            }
            if ((byArray = string.getBytes("utf-8")).length > 65535) {
                throw new PackException("String too big");
            }
            return this.push(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PackException(unsupportedEncodingException);
        }
    }

    public Pack pushFromByteString(String string) {
        try {
            byte[] byArray;
            if (string == null) {
                string = "";
            }
            if ((byArray = string.getBytes("ISO-8859-1")).length > 65535) {
                throw new PackException("String too big");
            }
            return this.push(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PackException(unsupportedEncodingException);
        }
    }

    public Pack push(String string, String string2) {
        try {
            byte[] byArray;
            if (string == null) {
                string = "";
            }
            if ((byArray = string.getBytes(string2)).length > 65535) {
                throw new PackException("String too big");
            }
            return this.push(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PackException(unsupportedEncodingException);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Pack [buffer=");
        stringBuilder.append(this.bufferString());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @SuppressLint(value={"DefaultLocale"})
    private String bufferString() {
        byte[] byArray = new byte[this.buffer.limit()];
        this.buffer.get(byArray);
        this.buffer.flip();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF).toUpperCase()).append(" ");
        }
        return stringBuffer.toString();
    }
}

