/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals.msgparser;

import com.hummer.im.HMR;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.MQService;
import com.hummer.im.chatroom._internals.packet.Receiver;
import com.hummer.im.chatroom._internals.packet.Uint64;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.id.User;
import java.util.ArrayList;
import java.util.List;

public class MemberChangeMsgParser
implements MQService.BCMessageParser {
    private static final String TAG = "MemberChangeMsgParser";

    public String serviceName() {
        return "chatroom_online_repair_d";
    }

    public String functionName() {
        return "UserOnlineChangeBc";
    }

    public HMR.Message parse(byte[] byArray) {
        Receiver receiver = new Receiver(byArray);
        receiver.parseHeader();
        if (receiver.getUri().intValue() != 3423949) {
            return null;
        }
        ChatRoomProto.PCS_ChatRoomUserBc pCS_ChatRoomUserBc = new ChatRoomProto.PCS_ChatRoomUserBc();
        receiver.unmarshallWrap(pCS_ChatRoomUserBc);
        ChatRoom chatRoom = new ChatRoom(pCS_ChatRoomUserBc.roomId.longValue());
        if (pCS_ChatRoomUserBc.joinUsers.size() > 0) {
            ArrayList<User> arrayList = new ArrayList<User>();
            for (Uint64 uint64 : pCS_ChatRoomUserBc.joinUsers) {
                Log.i((String)TAG, (Object)Trace.once().method("parse").msg((Object)("parse and add join use, uid = " + uint64)));
                arrayList.add(new User(uint64.longValue()));
            }
            return new MemberChangeMsg(chatRoom, arrayList, true);
        }
        if (pCS_ChatRoomUserBc.leaveUsers.size() > 0) {
            ArrayList<User> arrayList = new ArrayList<User>();
            for (Uint64 uint64 : pCS_ChatRoomUserBc.leaveUsers) {
                Log.i((String)TAG, (Object)Trace.once().method("parse").msg((Object)("parse and add leave use, uid = " + uint64)));
                arrayList.add(new User(uint64.longValue()));
            }
            return new MemberChangeMsg(chatRoom, arrayList, false);
        }
        return null;
    }

    public class MemberChangeMsg
    implements HMR.Message {
        public ChatRoom chatRoom;
        public List<User> users;
        public Boolean isJoin;

        MemberChangeMsg(ChatRoom chatRoom, List<User> list, Boolean bl) {
            this.chatRoom = chatRoom;
            this.users = list;
            this.isJoin = bl;
        }
    }
}

