/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.chatroom._internals;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.MQService;
import com.hummer.im.channel.Channel;
import com.hummer.im.chatroom.Challenges;
import com.hummer.im.chatroom.ChatRoomInfo;
import com.hummer.im.chatroom.ChatRoomService;
import com.hummer.im.chatroom._internals.msgparser.BroadcastMsgParser;
import com.hummer.im.chatroom._internals.msgparser.ChatRoomDismissMsgParser;
import com.hummer.im.chatroom._internals.msgparser.ChatRoomTextChatMsgParser;
import com.hummer.im.chatroom._internals.msgparser.KickOffMembersMsgParser;
import com.hummer.im.chatroom._internals.msgparser.MemberChangeMsgParser;
import com.hummer.im.chatroom._internals.msgparser.MemberCountChangeMsgParser;
import com.hummer.im.chatroom._internals.msgparser.MemberUpdateRoleMsgParser;
import com.hummer.im.chatroom._internals.msgparser.UnicastMsgParser;
import com.hummer.im.chatroom._internals.msgparser.UpdateChatRoomMsgParser;
import com.hummer.im.chatroom._internals.proto.ChatRoomProto;
import com.hummer.im.chatroom._internals.rpc.RPCChangeChatRoomInfo;
import com.hummer.im.chatroom._internals.rpc.RPCChangeChatRoomRole;
import com.hummer.im.chatroom._internals.rpc.RPCChatRoomTextChat;
import com.hummer.im.chatroom._internals.rpc.RPCCreateChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCDismissChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCFetchAdminList;
import com.hummer.im.chatroom._internals.rpc.RPCFetchChatRoomInfo;
import com.hummer.im.chatroom._internals.rpc.RPCFetchMemberList;
import com.hummer.im.chatroom._internals.rpc.RPCJoinChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCKickOffUser;
import com.hummer.im.chatroom._internals.rpc.RPCLeaveChatRoom;
import com.hummer.im.chatroom._internals.rpc.RPCPullAllAdminUser;
import com.hummer.im.chatroom._internals.rpc.RPCSendBroadcast;
import com.hummer.im.chatroom._internals.rpc.RPCSendUnicast;
import com.hummer.im.id.ChatRoom;
import com.hummer.im.id.ScopeAll;
import com.hummer.im.id.ScopeSignal;
import com.hummer.im.id.User;
import com.hummer.im.services.chat.ChatMessage;
import com.hummer.im.services.chat.contents.Text;
import com.hummer.im.services.notification.NotificationMessage;
import com.hummer.im.services.user.UserService;
import com.hummer.im.shared.DispatchQueue;
import com.hummer.im.shared.ServiceProvider;
import com.hummer.im.shared.completion.Completion;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;
import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.YYServiceCore;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTask;
import com.yy.platform.baseservice.utils.UserGroupType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ChatRoomServiceImpl
implements MQService.MQSubscriber,
Channel.StateChangedListener,
ChatRoomService {
    private static final int kickTimeSec = 300;
    private static final String TAG = "ChatRoomService";
    private static final long onlineBCGrpType = 0x80000002L;
    private static final long authBCGrpType = 0x80000001L;
    private static final long textChatBCGrpType = 0x80000000L;
    private final Set<ChatRoomService.ChatRoomMembterListener> memberListeners = new HashSet<ChatRoomService.ChatRoomMembterListener>();
    private final Set<ChatRoomService.ChatRoomListener> listeners = new HashSet<ChatRoomService.ChatRoomListener>();
    private final Set<ChatRoom> chatRooms = new HashSet<ChatRoom>();

    public Class[] staticDependencies() {
        return new Class[]{Channel.class};
    }

    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class};
    }

    public void initService() {
        MQService mQService = (MQService)HMR.getService(MQService.class);
        mQService.registerMessageParser((MQService.BCMessageParser)new ChatRoomTextChatMsgParser());
        mQService.registerMessageParser((MQService.BCMessageParser)new MemberCountChangeMsgParser());
        mQService.registerMessageParser((MQService.BCMessageParser)new UpdateChatRoomMsgParser());
        mQService.registerMessageParser((MQService.BCMessageParser)new MemberUpdateRoleMsgParser());
        mQService.registerMessageParser((MQService.BCMessageParser)new KickOffMembersMsgParser());
        mQService.registerMessageParser((MQService.BCMessageParser)new ChatRoomDismissMsgParser());
        mQService.registerMessageParser((MQService.BCMessageParser)new MemberChangeMsgParser());
        mQService.registerMessageParser((MQService.BCMessageParser)new BroadcastMsgParser());
        mQService.registerMessageParser((MQService.BCMessageParser)new UnicastMsgParser());
        ChatMessage.registerCustomMsgAdapt(ChatRoom.class, (message, completion) -> {
            ChatMessage chatMessage = (ChatMessage)message;
            Text text = (Text)chatMessage.getContent();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("uuid", chatMessage.getUuid());
            if (chatMessage.getAppExtra() != null) {
                hashMap.put("extra", chatMessage.getAppExtra());
            }
            return new RPCChatRoomTextChat(chatMessage.getReceiver().getId(), text.getText(), (Map<String, String>)hashMap, null, (Completion)completion);
        });
        NotificationMessage.registerCustomMsgAdapt(ScopeSignal.class, (message, completion) -> {
            NotificationMessage notificationMessage = (NotificationMessage)message;
            ScopeSignal scopeSignal = (ScopeSignal)notificationMessage.getReceiver();
            String string = notificationMessage.getNotifyMessage();
            return new RPCSendUnicast(scopeSignal.getId(), string, scopeSignal.getUser().getId(), (Completion)completion);
        });
        NotificationMessage.registerCustomMsgAdapt(ScopeAll.class, (message, completion) -> {
            NotificationMessage notificationMessage = (NotificationMessage)message;
            ScopeAll scopeAll = (ScopeAll)notificationMessage.getReceiver();
            String string = notificationMessage.getNotifyMessage();
            return new RPCSendBroadcast(scopeAll.getId(), string, (Completion)completion);
        });
    }

    public void openService(@NonNull Completion completion) {
        ((Channel)HMR.getService(Channel.class)).addStateListener((Channel.StateChangedListener)this);
        ((MQService)HMR.getService(MQService.class)).addSubscriber((MQService.MQSubscriber)this);
        CompletionUtils.dispatchSuccess((Completion)completion);
    }

    public void closeService() {
        ((MQService)HMR.getService(MQService.class)).removeSubscriber((MQService.MQSubscriber)this);
        ((Channel)HMR.getService(Channel.class)).removeStateListener((Channel.StateChangedListener)this);
    }

    @Override
    public void createChatRoom(@NonNull ChatRoomInfo chatRoomInfo, @NonNull CompletionArg<ChatRoom> completionArg) {
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure(completionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"createChatRoom subject:%s", (Object[])new Object[]{chatRoomInfo.getName()}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCCreateChatRoom(chatRoomInfo, completionArg));
    }

    @Override
    public void deleteChatRoom(@NonNull ChatRoom chatRoom, @Nullable CompletionArg<ChatRoom> completionArg) {
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure(completionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"deleteChatRoom chatRoom: %s", (Object[])new Object[]{chatRoom.getId()}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCDismissChatRoom(Long.valueOf(chatRoom.getId()).intValue(), completionArg));
    }

    @Override
    public void join(final @NonNull ChatRoom chatRoom, final @NonNull Challenges.JoiningCompletion joiningCompletion) {
        Log.i((String)TAG, (Object)Trace.once((String)"join chatRoom: %s", (Object[])new Object[]{chatRoom.getId()}));
        if (HMR.getState() != HMR.State.Opened) {
            DispatchQueue.main.async(() -> joiningCompletion.onFailed(new Error(1011, "User not login")));
            return;
        }
        if (HMR.getMe().isAnonymous()) {
            HMRContext.work.async(() -> this._subscribeChatRoomBC(chatRoom, new Completion().onSuccess(() -> DispatchQueue.main.async(joiningCompletion::onSucceed)).onFailure(error -> DispatchQueue.main.async(() -> joiningCompletion.onFailed(error)))));
        } else {
            HMRContext.work.async(() -> ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCJoinChatRoom((int)chatRoom.getId(), new HashMap<String, String>(), new Challenges.JoiningCompletion(){

                @Override
                public void onReceiveChallenge(Challenges.Password password) {
                    DispatchQueue.main.async(() -> joiningCompletion.onReceiveChallenge(password));
                }

                @Override
                public void onReceiveChallenge(Challenges.AppChallenge appChallenge) {
                    DispatchQueue.main.async(() -> joiningCompletion.onReceiveChallenge(appChallenge));
                }

                @Override
                public void onSucceed() {
                    ChatRoomServiceImpl.this.addChatRoom(chatRoom);
                    ChatRoomServiceImpl.this._subscribeChatRoomBC(chatRoom, new Completion().onSuccess(() -> DispatchQueue.main.async(joiningCompletion::onSucceed)).onFailure(this::onFailed));
                }

                @Override
                public void onFailed(@NonNull Error error) {
                    DispatchQueue.main.async(() -> joiningCompletion.onFailed(error));
                }
            })));
        }
    }

    @Override
    public void leave(@NonNull ChatRoom chatRoom, @Nullable Completion completion) {
        Log.i((String)TAG, (Object)Trace.once((String)"join chatRoom: %s", (Object[])new Object[]{chatRoom.getId()}));
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure((Completion)completion, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"leave chatRoom: %s", (Object[])new Object[]{chatRoom.getId()}));
        HMRContext.work.async(() -> {
            if (HMR.getMe().isAnonymous()) {
                this._unsubscribeChatRoomBC(chatRoom);
                CompletionUtils.dispatchSuccess((Completion)completion);
            } else {
                this.removeChatRoom(chatRoom);
                ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCLeaveChatRoom((int)chatRoom.getId(), (CompletionArg<ChatRoom>)new CompletionArg().onSuccess(chatRoom2 -> {
                    this._unsubscribeChatRoomBC(chatRoom);
                    CompletionUtils.dispatchSuccess((Completion)completion);
                }).onFailure(error -> CompletionUtils.dispatchFailure((Completion)completion, (Error)error))));
            }
        });
    }

    @Override
    public void kick(@NonNull ChatRoom chatRoom, @NonNull User user, @Nullable Map<ChatRoomService.EKickInfo, String> map, @NonNull CompletionArg<ChatRoom> completionArg) {
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure(completionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"kick id:%s fellow:%s", (Object[])new Object[]{chatRoom.getId(), user.getId()}));
        HMRContext.work.async(() -> {
            long l = 300L;
            String string = "";
            if (map != null && map.containsKey((Object)ChatRoomService.EKickInfo.Time)) {
                l = Long.parseLong((String)map.get((Object)ChatRoomService.EKickInfo.Time));
            }
            if (map != null && map.containsKey((Object)ChatRoomService.EKickInfo.Reason)) {
                string = (String)map.get((Object)ChatRoomService.EKickInfo.Reason);
            }
            ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCKickOffUser(user.getId(), (int)chatRoom.getId(), l, string, completionArg));
        });
    }

    @Override
    public void addRole(@NonNull ChatRoom chatRoom, @NonNull User user, @NonNull String string, @NonNull CompletionArg<ChatRoom> completionArg) {
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure(completionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"addRole id:%s fellow:%s role:%s", (Object[])new Object[]{chatRoom.getId(), user.getId(), string}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCChangeChatRoomRole(chatRoom.getId(), user.getId(), new ChatRoomProto.AdminRoleTypeEnum(string), ChatRoomProto.ChatRoomOpEnum.ADD, completionArg));
    }

    @Override
    public void removeRole(@NonNull ChatRoom chatRoom, @NonNull User user, @NonNull String string, @NonNull CompletionArg<ChatRoom> completionArg) {
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure(completionArg, (Error)new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"removeRole id:%s fellow:%s role:%s", (Object[])new Object[]{chatRoom.getId(), user.getId(), string}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCChangeChatRoomRole(chatRoom.getId(), user.getId(), new ChatRoomProto.AdminRoleTypeEnum(string), ChatRoomProto.ChatRoomOpEnum.REMOVE, completionArg));
    }

    @Override
    public void fetchMembers(@NonNull ChatRoom chatRoom, int n, int n2, @NonNull CompletionArg<List<User>> completionArg) {
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure(completionArg, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"fetchMembers id:%s num:%s pos:%s", (Object[])new Object[]{chatRoom.getId(), n, n2}));
        HMRContext.work.async(() -> ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCFetchMemberList((int)chatRoom.getId(), n, n2, completionArg)));
    }

    @Override
    public void fetchRoleMembers(@NonNull ChatRoom chatRoom, boolean bl, @NonNull CompletionArg<Map<String, List<User>>> completionArg) {
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure(completionArg, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"fetch all roler Members id:%s, online:%s", (Object[])new Object[]{chatRoom.getId(), bl}));
        if (bl) {
            ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCFetchAdminList((int)chatRoom.getId(), "all", completionArg));
        } else {
            ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCPullAllAdminUser((int)chatRoom.getId(), "all", completionArg));
        }
    }

    @Override
    public void fetchBasicInfo(@NonNull ChatRoom chatRoom, @NonNull CompletionArg<ChatRoomInfo> completionArg) {
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure(completionArg, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"fetchBasicInfo id:%s", (Object[])new Object[]{chatRoom.getId()}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCFetchChatRoomInfo((int)chatRoom.getId(), completionArg));
    }

    @Override
    public void changeBasicInfo(@NonNull ChatRoom chatRoom, @NonNull Map<ChatRoomInfo.BasicInfoType, String> map, @Nullable Completion completion) {
        if (HMR.getState() != HMR.State.Opened) {
            CompletionUtils.dispatchFailure((Completion)completion, (Error)new Error(1011, "User not login"));
            return;
        }
        Log.i((String)TAG, (Object)Trace.once((String)"changeBasicInfo id:%s", (Object[])new Object[]{chatRoom.getId()}));
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCChangeChatRoomInfo((int)chatRoom.getId(), map, completion));
    }

    @Override
    public void addListener(@NonNull ChatRoomService.ChatRoomListener chatRoomListener) {
        this.listeners.add(chatRoomListener);
        Log.d((String)TAG, (Object)Trace.once().method("addListener").info("name", (Object)chatRoomListener.getClass().getSimpleName()).info("size", (Object)this.listeners.size()));
    }

    @Override
    public void removeListener(@NonNull ChatRoomService.ChatRoomListener chatRoomListener) {
        this.listeners.remove(chatRoomListener);
        Log.d((String)TAG, (Object)Trace.once().method("removeListener").info("name", (Object)chatRoomListener.getClass().getSimpleName()).info("size", (Object)this.listeners.size()));
    }

    @Override
    public void addMemberListener(@NonNull ChatRoomService.ChatRoomMembterListener chatRoomMembterListener) {
        this.memberListeners.add(chatRoomMembterListener);
        Log.d((String)TAG, (Object)Trace.once().method("addMemberListener").info("name", (Object)chatRoomMembterListener.getClass().getSimpleName()).info("size", (Object)this.memberListeners.size()));
    }

    @Override
    public void removeMemberListener(@NonNull ChatRoomService.ChatRoomMembterListener chatRoomMembterListener) {
        this.memberListeners.remove(chatRoomMembterListener);
        Log.d((String)TAG, (Object)Trace.once().method("removeMemberListener").info("name", (Object)chatRoomMembterListener.getClass().getSimpleName()).info("size", (Object)this.memberListeners.size()));
    }

    public boolean shouldReceiveMessage(HMR.Message message) {
        return message instanceof MemberCountChangeMsgParser.MemberCountChangeMsg || message instanceof UpdateChatRoomMsgParser.UpdateChatRoomMsg || message instanceof MemberUpdateRoleMsgParser.MemberUpdateRoleMsg || message instanceof KickOffMembersMsgParser.KickOffMembersMsg || message instanceof ChatRoomDismissMsgParser.ChatRoomDismissMsg || message instanceof MemberChangeMsgParser.MemberChangeMsg;
    }

    public void onReceiveMessage(HMR.Message message) {
        DispatchQueue.main.async(() -> {
            block9: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    if (!(message instanceof MemberCountChangeMsgParser.MemberCountChangeMsg)) break block8;
                                    MemberCountChangeMsgParser.MemberCountChangeMsg memberCountChangeMsg = (MemberCountChangeMsgParser.MemberCountChangeMsg)message;
                                    for (ChatRoomService.ChatRoomMembterListener chatRoomMembterListener : this.memberListeners) {
                                        chatRoomMembterListener.onMemberCount(memberCountChangeMsg.chatRoom, memberCountChangeMsg.count);
                                    }
                                    break block9;
                                }
                                if (!(message instanceof UpdateChatRoomMsgParser.UpdateChatRoomMsg)) break block10;
                                UpdateChatRoomMsgParser.UpdateChatRoomMsg updateChatRoomMsg = (UpdateChatRoomMsgParser.UpdateChatRoomMsg)message;
                                for (ChatRoomService.ChatRoomListener chatRoomListener : this.listeners) {
                                    chatRoomListener.onBasicInfoChanged(updateChatRoomMsg.chatRoom, updateChatRoomMsg.changeBasicInfoMap);
                                }
                                break block9;
                            }
                            if (!(message instanceof MemberUpdateRoleMsgParser.MemberUpdateRoleMsg)) break block11;
                            MemberUpdateRoleMsgParser.MemberUpdateRoleMsg memberUpdateRoleMsg = (MemberUpdateRoleMsgParser.MemberUpdateRoleMsg)message;
                            for (ChatRoomService.ChatRoomMembterListener chatRoomMembterListener : this.memberListeners) {
                                if (memberUpdateRoleMsg.isAdd.booleanValue()) {
                                    chatRoomMembterListener.onRoleAdded(memberUpdateRoleMsg.chatRoom, memberUpdateRoleMsg.role, memberUpdateRoleMsg.admin, memberUpdateRoleMsg.user);
                                    continue;
                                }
                                chatRoomMembterListener.onRoleRemoved(memberUpdateRoleMsg.chatRoom, memberUpdateRoleMsg.role, memberUpdateRoleMsg.admin, memberUpdateRoleMsg.user);
                            }
                            break block9;
                        }
                        if (!(message instanceof KickOffMembersMsgParser.KickOffMembersMsg)) break block12;
                        KickOffMembersMsgParser.KickOffMembersMsg kickOffMembersMsg = (KickOffMembersMsgParser.KickOffMembersMsg)message;
                        for (ChatRoomService.ChatRoomMembterListener chatRoomMembterListener : this.memberListeners) {
                            chatRoomMembterListener.onMemberKicked(kickOffMembersMsg.chatRoom, kickOffMembersMsg.admin, kickOffMembersMsg.kickedUsers, kickOffMembersMsg.reason);
                        }
                        break block9;
                    }
                    if (!(message instanceof ChatRoomDismissMsgParser.ChatRoomDismissMsg)) break block13;
                    ChatRoomDismissMsgParser.ChatRoomDismissMsg chatRoomDismissMsg = (ChatRoomDismissMsgParser.ChatRoomDismissMsg)message;
                    for (ChatRoomService.ChatRoomListener chatRoomListener : this.listeners) {
                        chatRoomListener.onDeleteChatRoom(chatRoomDismissMsg.chatRoom, chatRoomDismissMsg.operator);
                    }
                    break block9;
                }
                if (!(message instanceof MemberChangeMsgParser.MemberChangeMsg)) break block9;
                MemberChangeMsgParser.MemberChangeMsg memberChangeMsg = (MemberChangeMsgParser.MemberChangeMsg)message;
                for (ChatRoomService.ChatRoomMembterListener chatRoomMembterListener : this.memberListeners) {
                    if (memberChangeMsg.isJoin.booleanValue()) {
                        Log.i((String)TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("member join, size = " + memberChangeMsg.users.size())));
                        chatRoomMembterListener.onMemberJoin(memberChangeMsg.chatRoom, memberChangeMsg.users);
                        continue;
                    }
                    Log.i((String)TAG, (Object)Trace.once().method("onReceiveMessage").msg((Object)("member leave, size = " + memberChangeMsg.users.size())));
                    chatRoomMembterListener.onMemberLeave(memberChangeMsg.chatRoom, memberChangeMsg.users);
                }
            }
        });
    }

    private void addChatRoom(ChatRoom chatRoom) {
        this.chatRooms.add(chatRoom);
    }

    private void removeChatRoom(ChatRoom chatRoom) {
        this.chatRooms.remove(chatRoom);
    }

    private void _subscribeChatRoomBC(ChatRoom chatRoom, final @NonNull Completion completion) {
        final long l = chatRoom.getId();
        UserGroupType userGroupType = new UserGroupType(0x80000000L, l);
        UserGroupType userGroupType2 = new UserGroupType(0x80000001L, l);
        UserGroupType userGroupType3 = new UserGroupType(0x80000002L, l);
        ArrayList<UserGroupType> arrayList = new ArrayList<UserGroupType>();
        arrayList.add(userGroupType);
        arrayList.add(userGroupType2);
        arrayList.add(userGroupType3);
        YYServiceCore.getInstance().subscribeBroadcast(arrayList, (IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam>(){

            public void onSuccess(int n, BroadSubOrUnSubTask.ResponseParam responseParam) {
                Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("subscribeBroadcast success").msg("resCode:%d, roomId:%d", new Object[]{responseParam.mResCode, l}));
                CompletionUtils.dispatchSuccess((Completion)completion);
            }

            public void onFail(int n, int n2, int n3, Exception exception) {
                Log.e((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("subscribeBroadcast failed").msg("sdkResCode:%d, srvResCode:%d, roomId:%d", new Object[]{n2, n3, l}));
                CompletionUtils.dispatchFailure((Completion)completion, (Error)new Error(n3, "service err"));
            }
        });
    }

    private void _unsubscribeChatRoomBC(ChatRoom chatRoom) {
        final long l = chatRoom.getId();
        UserGroupType userGroupType = new UserGroupType(0x80000000L, l);
        UserGroupType userGroupType2 = new UserGroupType(0x80000001L, l);
        UserGroupType userGroupType3 = new UserGroupType(0x80000002L, l);
        ArrayList<UserGroupType> arrayList = new ArrayList<UserGroupType>();
        arrayList.add(userGroupType);
        arrayList.add(userGroupType2);
        arrayList.add(userGroupType3);
        YYServiceCore.getInstance().unSubscribeBroadcast(arrayList, (IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam>(){

            public void onSuccess(int n, BroadSubOrUnSubTask.ResponseParam responseParam) {
                Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("unSubscribeBroadcast success").msg("resCode:%d, roomId:%d", new Object[]{responseParam.mResCode, l}));
            }

            public void onFail(int n, int n2, int n3, Exception exception) {
                Log.i((String)ChatRoomServiceImpl.TAG, (Object)Trace.once().method("unSubscribeBroadcast failed").msg("sdkResCode:%d, srvResCode:%d, roomId:%d", new Object[]{n2, n3, l}));
            }
        });
    }

    public void onChannelConnected() {
        Log.i((String)TAG, (Object)Trace.once().method("onChannelConnected"));
        this.rejoinChatRoom();
    }

    public void onChannelDisconnected() {
        Log.i((String)TAG, (Object)Trace.once().method("onChannelDisconnected"));
    }

    private void rejoinChatRoom() {
        if (this.chatRooms.size() > 0) {
            for (ChatRoom chatRoom : this.chatRooms) {
                Log.i((String)TAG, (Object)String.format(Locale.US, "rejoin chatRoom after channel connected, roomId:%d", chatRoom.getId()));
                if (HMR.getMe() == null) continue;
                ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCJoinChatRoom((int)chatRoom.getId(), new HashMap<String, String>(), null));
            }
        }
    }
}

